% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{obtainDesign}
\alias{obtainDesign}
\title{Finds optimal and minimax designs for either Simon's 2-stage or Mander &
Thompson studies}
\usage{
obtainDesign(
  grid = NULL,
  p0 = NA,
  p1 = NA,
  alpha = ifelse(is.null(grid), 0.05, NA),
  beta = ifelse(is.null(grid), 0.1, NA),
  fullGrid = FALSE,
  ...
)
}
\arguments{
\item{grid}{Optional. A tibble created by \code{createGrid}.  If \code{NULL},
then \code{p0}, \code{p1}, \code{alpha} and \code{beta} must be specified
and \code{createGrid} is called to generate the required grid.  If not
\code{NULL} then \code{p0}, \code{p1}, \code{alpha} and \code{beta} are
ignored}

\item{p0}{the response rate under the null hypothesis}

\item{p1}{the response rate under the alternate hypothesis}

\item{alpha}{the desired (one-sided) type 1 error rate}

\item{beta}{the desired type 2 error rate}

\item{fullGrid}{should the full grid of all possible designs be returned, or
simply the optimal and minimax solutions?  For a Mander and Thompson design,
optimal and minimax designs are returned for both the null and alternate
hypotheses.  See Usage Notes below.}

\item{...}{passed to `createGrid` or `augmentGrid`.  In particular
\code{mander=TRUE} for a Mander & Thompson design or \code{mander=FALSE} for
a Simon's 2-stage design.}
}
\value{
a tibble created by \code{\link{createGrid}}.  If
 \code{fullGrid == FALSE} the table contains an additional column,
 \code{Criterion} indicating the type of design.  Possible values for
 \code{Criterion} are "optimal" and "minimax" for Simon's designs and
 "optimalNull", "optimalAlt", "minimaxNull" and "minimaxAlt" for Mander &
 Thompson designs.
}
\description{
\code{obtainDesign} is essentially a wrapper for calls to
\code{\link{createGrid}} and \code{\link{augmentGrid}} followed by some
simple filtering of the candidate designs to identify the optimal and
minimax designs.
}
\section{Usage notes}{

If \code{grid} is not \code{NULL} it is possible that none of the candidate
designs are acceptable (that is, satisfy both the significance level and
power requirements).  If this is the case and \code{fullGrid == FALSE}, then
an empty tibble is returned.  If \code{versbose == TRUE} a warning message is
 also printed.
If \code{fullGrid == TRUE} the full grid of all designs considered is
returned.  This can then be further interrogated to find optimal designs
 under constraints - for example with fixed stage sizes.
}

\examples{
\donttest{
# Standard use (Simon's 2-stage design)
createGrid(p0 = 0.05, p1 = 0.25, alpha = 0.05, beta = 0.2, mander = FALSE) \%>\%
  augmentGrid(parallel = FALSE) \%>\%
  obtainDesign()
# Constrained stage sizes
createGrid(p0 = 0.25, p1 = 0.45, alpha = 0.05, beta = 0.2) \%>\%
  dplyr::filter(nStage1 == 8) \%>\%
  augmentGrid(parallel = FALSE) \%>\%
  obtainDesign()
}
}
