% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fortenums}
\alias{fortenums}
\title{Allen Forte's list of set classes}
\format{
A list of length 12. The nth entry of the list corresponds to set classes of
cardinality n. Each list entry is a vector of character strings; every element
of the vector contains a Rahn prime form as a comma-delimited string. These prime
forms are ordered in the same sequence as Forte's list. Thus, for instance, the
set class of the minor triad is represented by the string \code{"0, 3, 7"}, which is
the 11th element in \code{fortenums[[3]]}.
}
\source{
Forte, Allen. 1973. \emph{The Structure of Atonal Music}. New Haven, CT:
Yale University Press. Appendix 1, pp. 179-181.
}
\usage{
fortenums
}
\description{
For compatibility with music theory's traditional pitch-class set theory,
whose landmark text is Allen Forte's 1973 \emph{The Structure of Atonal Music},
the data set \code{fortenums} hard-codes the ordinal positions of 12-equal pitch-class
set classes from Allen Forte's list. This allows us to look up specific set
classes from Forte numbers or vice versa. \code{\link[=sc]{sc()}} does the former and
\code{\link[=fortenum]{fortenum()}} does the latter. There's very little need to ever interact with
the file \code{fortenums} itself: you should be able to get anything you need from this
data through either \code{\link[=sc]{sc()}} or \code{\link[=fortenum]{fortenum()}}.

Note that \code{\link[=primeform]{primeform()}} in \code{musicMCT}
uses Rahn's algorithm rather than Forte's for finding a canonical representative
of each set class. Consequently, the entries of \code{fortenums} also use Rahn's prime
forms rather than Forte's.
}
\keyword{datasets}
