% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mvgam_factors.R
\name{plot_mvgam_factors}
\alias{plot_mvgam_factors}
\title{Latent factor summaries for a fitted \pkg{mvgam} object}
\usage{
plot_mvgam_factors(object, plot = TRUE)
}
\arguments{
\item{object}{\code{list} object returned from \code{mvgam}. See \code{\link[=mvgam]{mvgam()}}}

\item{plot}{\code{logical} specifying whether factors should be plotted}
}
\value{
A \code{data.frame} of factor contributions
}
\description{
This function takes a fitted \code{mvgam} object and returns plots and
summary statistics for the latent dynamic factors
}
\details{
If the model in \code{object} was estimated using dynamic factors,
it is possible that not all factors contributed to the estimated trends.
This is due to the regularisation penalty that acts independently on each
factor's Gaussian precision, which will squeeze un-needed factors to a
white noise process (effectively dropping that factor from the model). In
this function, each factor is tested against a null hypothesis of white
noise by calculating the sum of the factor's 2nd derivatives. A factor
that has a larger contribution will have a larger sum due to the weaker
penalty on the factor's precision. If \code{plot == TRUE}, the factors
are also plotted.
}
\examples{
\donttest{
simdat <- sim_mvgam()

mod <- mvgam(
  y ~ s(season, bs = 'cc', k = 6),
  trend_model = AR(),
  use_lv = TRUE,
  n_lv = 2,
  data = simdat$data_train,
  chains = 2,
  silent = 2
)

plot_mvgam_factors(mod)
}

}
\author{
Nicholas J Clark
}
