% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_stats.R
\name{load_team_stats}
\alias{load_team_stats}
\title{Load Team Level Stats}
\usage{
load_team_stats(
  seasons = most_recent_season(),
  ...,
  summary_level = c("week", "reg", "post", "reg+post"),
  file_type = getOption("nflreadr.prefer", default = "rds")
)
}
\arguments{
\item{seasons}{a numeric vector of seasons to return, defaults to most recent
season. If set to \code{TRUE}, returns all available data.}

\item{...}{These dots are for future extensions and must be empty.}

\item{summary_level}{choice: one of week (default), "reg" for regular season,
"post" for postseason, "reg+post" for combined regular + post season stats}

\item{file_type}{choice: one of \code{c("rds", "qs", "csv", "parquet")}. Can also
be set globally with \code{options(nflreadr.prefer)}}
}
\value{
A tibble of team statistics that aims to match NFL official box scores
and season summaries
}
\description{
Load Team Level Stats
}
\examples{
\dontshow{.for_cran()}
\donttest{
try({
  load_team_stats()
})
}

}
\seealso{
\url{https://nflreadr.nflverse.com/articles/dictionary_team_stats.html}
for a web version of the data dictionary

\code{\link{dictionary_team_stats}} for the data dictionary
}
