% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabular_problemas_em_nomes.R
\name{tabular_problemas_em_nomes}
\alias{tabular_problemas_em_nomes}
\alias{tabulate_name_poblems}
\title{Tabula Problemas Detectados nos Nomes}
\usage{
tabular_problemas_em_nomes(d, s)

tabulate_name_poblems(d, s)
}
\arguments{
\item{d}{O `data.table` retornado por `marcar_problemas_e_limpar_nomes`.}

\item{s}{O nome da coluna original (string) que foi processada.}
}
\value{
Um `data.table` com as colunas:
  \itemize{
    \item `condition`: O nome da condição/problema verificado.
    \item `N_detected`: Número de vezes que a condição foi detectada.
    \item `N_made_NA`: Número de detecções que resultaram na limpeza para `NA`.
    \item `N_replaced`: Número de detecções onde o nome foi alterado (não para `NA`).
  }
}
\description{
Cria uma tabela resumo contabilizando o número de ocorrências para cada
tipo de problema detectado pela função `marcar_problemas_e_limpar_nomes`.
}
\examples{
DT_limpo <- data.table::data.table(nome = c("JOSEE SILVA", 
"RAIMUNDA DA DA SILVA"), nome_clean = c("JOSE SILVA",
"RAIMUNDA DA SILVA"),
falecido = NA, cartorio = NA, 
espaco_TilAcentoApostrofe = NA, 
nome_P_M_S_N = NA, nada_nao = NA, 
nada_nao_consta2 = NA, final_missing = NA, Xartigo = NA, sr_sra = NA,
ignorado = NA, dededada = 1, letra_repetida = 1)
sumario <- tabular_problemas_em_nomes(DT_limpo, "nome")
print(sumario)
}
