% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_arg.R
\name{match_arg}
\alias{match_arg}
\title{Argument matching}
\usage{
match_arg(arg, choices, several.ok = FALSE, none.ok = FALSE)
}
\arguments{
\item{arg}{[\code{character()}]\cr
The function argument.}

\item{choices}{[\code{character()}]\cr
Allowed values for \code{arg}.}

\item{several.ok}{[\code{logical(1)}]\cr
Is \code{arg} allowed to have more than one element?}

\item{none.ok}{[\code{logical(1)}]\cr
Is \code{arg} allowed to have zero elements?}
}
\value{
The un-abbreviated version of the exact or unique partial match if there is
one. Otherwise, an error is signaled if \code{several.ok} is \code{FALSE}
or \code{none.ok} is \code{FALSE}.
When \code{several.ok} is \code{TRUE} and (at least) one element of
\code{arg} has a match, all un-abbreviated versions of matches are returned.
When \code{none.ok} is \code{TRUE} and \code{arg} has zero elements,
\code{character(0)} is returned.
}
\description{
This function matches function arguments and is a modified version of
\code{\link[base]{match.arg}}.
}
\seealso{
Other package helpers: 
\code{\link{Dictionary}},
\code{\link{Storage}},
\code{\link{check_missing}()},
\code{\link{find_namespace_calls}()},
\code{\link{identical_structure}()},
\code{\link{input_check_response}()},
\code{\link{package_logo}()},
\code{\link{print_data.frame}()},
\code{\link{print_matrix}()},
\code{\link{system_information}()},
\code{\link{unexpected_error}()},
\code{\link{user_confirm}()}
}
\concept{package helpers}
\keyword{packaging}
