% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orderly.R
\name{orderly_new}
\alias{orderly_new}
\title{Create a new report}
\usage{
orderly_new(name, template = NULL, force = FALSE, root = NULL)
}
\arguments{
\item{name}{The name of the report}

\item{template}{The template to use. The only acceptable values
for now are \code{NULL} (uses the built-in default) and \code{FALSE} which
suppresses any default content.  We may support customisable
templates in future - let us know if this would be useful.}

\item{force}{Create an orderly file - \verb{<name>.R} within an existing
directory \verb{src/<name>}; this may be useful if you have already
created the directory and some files first but want help
creating the orderly file.}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function \strong{does} require that the directory is
configured for orderly, and not just outpack (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
Nothing, called for its side effects only
}
\description{
Create a new empty report.
}
\examples{
path <- withr::local_tempdir()

# Initialise a new repository, setting an option:
orderly_init(path)

# Create a new report 'myreport' in this root:
orderly_new("myreport", root = path)

# We now see:
fs::dir_tree(path, all = TRUE)

# By default, the new path will contain some hints, you can
# customise this by writing a template
cli::cli_code(readLines(file.path(path, "src", "myreport", "myreport.R")))
}
