% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_queries.R
\name{pbdb_ref_collections}
\alias{pbdb_ref_collections}
\title{Get references from which collection data were entered}
\usage{
pbdb_ref_collections(...)
}
\arguments{
\item{...}{Arguments passed to the API. See documentation for
accepted parameters at
\url{https://paleobiodb.org/data1.2/colls/refs}. E.g.:
\itemize{
\item \code{coll_id}: List of collection identifiers.
\item \code{ref_author}: Select only references for which any of the authors
matches the specified name.
\item \code{ref_pubyr}: Select only references published in the specified
year.
\item \code{pub_title}: Select only references that involve the specified
publication.
\item \code{order}: Specifies the order in which the results are
returned. You can specify multiple values separated by commas,
and each value may be appended with .asc or .desc. Accepted
values are: \code{"author"}, \code{"pubyr"}, \code{"reftitle"}, \code{"pubtitle"},
\code{"pubtype"}, \code{"created"}, \code{"modified"}, \code{"rank"}.
}}
}
\value{
A data frame with the information about the references that
match the query.
}
\description{
Returns information about the references from which the selected
collection data were entered.
}
\examples{
\dontrun{
  pbdb_ref_collections(
    base_name = "Canidae",
    interval = "Quaternary",
    cc = "ASI"
  )
}
}
