% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testGrowth.R
\name{testGrowth}
\alias{testGrowth}
\title{Hypothesis testing for \link{fitGrowth} models.}
\usage{
testGrowth(ss = NULL, fit, test = "A")
}
\arguments{
\item{ss}{A list output from \link{growthSS}. This is not required for nls, nlme, and brms models
if \code{test} is given in \code{brms::hypothesis} style as a written statement.}

\item{fit}{A model (or list of nlrq models) output from \link{fitGrowth}. For brms models this
can also be a data.frame of draws.}

\item{test}{A description of the hypothesis to test. This can take two main forms,
either the parameter names to vary before comparing a nested model ("A", "B", "C") using an anova
or a hypothesis test/list of hypothesis tests written as character strings.
The latter method is not implemented for \code{nlrq} models. If this is a vector of parameters
to test in the model then they should be parameters which vary by group in your original model
and that you want to test against a null model where they do not vary by group.
Alternatively for nlrq models this can be a comparison of model terms
written as \code{"group_X|tau|par - group_Y|tau|par"}, which uses a fat tailed T distribution to make
comparisons on the means of each quantile estimate. For GAMs these tests compare the model with
splines either by group or interacting with group to a model that ignores the grouping in the data.
If this is a list of hypothesis tests then they should describe tests similar to
"A.group1 - A.group2*1.1" and can be thought of as contrasts. For brms models the "test" argument
is passed to brms::hypothesis, which has extensive documentation and is very flexible.
Note that for survreg the \code{survival::survdiff} function is used so fewer hypothesis testing
options are available and flexsurv models are tested using contrasts via \code{flexsurv::standsurv}.}
}
\value{
A list containing an anova object comparing non-linear growth models and the null model.
}
\description{
Hypothesis testing for \link{fitGrowth} models.
}
\details{
For nls and nlme models an anova is run and returned as part of a list along with the null model.
 For nlrq models several assumptions are made and a likelihood ratio test for each tau
 is run and returned as a list.
}
\examples{

set.seed(123)
simdf <- growthSim("logistic",
  n = 20, t = 25,
  params = list("A" = c(200, 160), "B" = c(13, 11), "C" = c(3, 3.5))
)
ss <- suppressMessages(growthSS(
  model = "logistic", form = y ~ time | id / group,
  df = simdf, type = "nlrq"
))
fit <- fitGrowth(ss)
testGrowth(ss, fit, "A")
testGrowth(ss, fit, "a|0.5|A > b|0.5|A")

ss2 <- suppressMessages(growthSS(
  model = "logistic", form = y ~ time | id / group,
  df = simdf, type = "nls"
))
fit2 <- fitGrowth(ss2)
testGrowth(ss2, fit2, "A")$anova
coef(fit2) # check options for contrast testing
testGrowth(ss2, fit2, "A1 - A2*1.1")

}
\seealso{
\link{growthSS} and \link{fitGrowth} for making compatible models, \link{growthPlot}
for hypothesis testing on compatible models.
}
\keyword{brms}
\keyword{hypothesis}
\keyword{mgcv}
\keyword{nlme}
\keyword{nlrq}
\keyword{nls}
