% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_locusattributes.R
\name{locusAttributes}
\alias{locusAttributes}
\alias{getLocusAttributes}
\alias{setLocusAttributes}
\title{Get or set locus attributes}
\usage{
getLocusAttributes(
  x,
  markers = NULL,
  attribs = c("alleles", "afreq", "name", "chrom", "posMb", "mutmod"),
  checkComps = FALSE,
  simplify = FALSE
)

setLocusAttributes(
  x,
  markers = NULL,
  locusAttributes,
  matchNames = NA,
  erase = FALSE
)
}
\arguments{
\item{x}{A \code{ped} object, or a list of such.}

\item{markers}{A character vector (with marker names) or a numeric vector
(with marker indices). If NULL (default), the behaviour depends on
\code{matchNames}, see Details.}

\item{attribs}{A subset of the character vector \code{c("alleles", "afreq", "name" ,"chrom" ,"posMb", "mutmod", "rate")}.}

\item{checkComps}{A logical. If TRUE, and \code{x} is a list of pedigrees, an
error is raised if marker attributes differ between components.}

\item{simplify}{A logical. If TRUE, and \code{attribs} is a single element, the
output is flattened to a simple list.}

\item{locusAttributes}{A list of lists, with attributes for each marker.}

\item{matchNames}{A logical, only relevant if \code{markers = NULL}. If TRUE, then
the markers to be modified are identified by the 'name' component of each
\code{locusAttributes} entry. If FALSE, all markers attached to \code{x} are selected
in order.}

\item{erase}{A logical. If TRUE, all previous attributes of the selected
markers are erased. If FALSE, attributes not affected by the submitted
\code{locusAttributes} remain untouched.}
}
\value{
\itemize{
\item \code{getLocusAttributes}: a list of lists. If the markers have names,
these are used to name the outer list. If \code{simplify = TRUE} and \code{attribs} is
a single element, the output is a simple list.
\item \code{setLocusAttributes}: a modified version of \code{x}.
}
}
\description{
Retrieve or modify the attributes of attached markers
}
\details{
The default setting \code{markers = NULL} selects markers automatically, depending
on the \code{matchNames} argument. If \code{matchNames = FALSE}, all markers are
chosen. If \code{matchNames = TRUE}, markers will be matched against the \code{name}
entries in \code{locusAttributes} (and an error issued if any are missing).

Note that the default value \code{NA} of \code{matchNames} is changed to TRUE if all
entries of \code{locusAttributes} have a \code{name} component which matches the name
of an attached marker.

Possible attributes given in \code{locusAttributes} are as follows (default values
in parentheses):
\itemize{
\item \code{alleles}: a character vector with allele labels
\item \code{afreq}:  a numeric vector with allele frequencies (\code{rep.int(1/L, L)},
where \code{L = length(alleles)})
\item \code{name}: marker name (NA)
\item \code{chrom}: chromosome number (NA)
\item \code{posMb}: physical location in megabases (NA)
\item \code{mutmod}: mutation model, or model name (NULL)
\item \code{rate}: mutation model parameter (NULL)
}
}
\examples{
x = singleton(1) |>
  addMarker(name = "m1", alleles = 1:2) |>
  addMarker(name = "m2", alleles = letters[1:2], chrom = "X")

# By default, the markers to be modified are identified by name
locs = list(list(name = "m1", alleles = 1:10),
            list(name = "m2", alleles = letters[1:10]))
y = setLocusAttributes(x, locusAttributes = locs)
getMarkers(y, 1:2)

# If `erase = TRUE` attributes not explicitly given are erased
y2 = setLocusAttributes(x, locusAttributes = locs, erase = TRUE)
chrom(y2, 2) # not "X" anymore

# The getter and setter are inverses
newx = setLocusAttributes(x, locusAttributes = getLocusAttributes(x))
stopifnot(identical(x, newx))

}
