% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timesToHours.R
\name{convertToHours}
\alias{convertToHours}
\title{Convert Time to Hours.}
\usage{
convertToHours(hours, minutes, seconds, HHMMSS, HHMM)
}
\arguments{
\item{hours}{Character vector of the number of hours.}

\item{minutes}{Character vector of the number of minutes.}

\item{seconds}{Character vector of the number of seconds.}

\item{HHMMSS}{Times in HH:MM:SS format.}

\item{HHMM}{Character vector of times in HH:MM format.}
}
\value{
Vector of times in hours.
}
\description{
Convert times to hours.
}
\details{
Converts times to hours. To convert times to minutes or seconds, see
\link{convertToMinutes} or \link{convertToSeconds}.
}
\examples{
# Prepare Data
df <- data.frame(hours = c(0,1), minutes = c(15,27), seconds = c(30,13),
  HHMMSS = c("00:15:30","01:27:13"), HHMM = c("00:15","01:27"))

# Convert to Hours
convertToHours(hours = df$hours, minutes = df$minutes, seconds = df$seconds)
convertToHours(HHMMSS = df$HHMMSS)
convertToHours(HHMM = df$HHMM)
}
\seealso{
Other times: 
\code{\link{convertHoursAMPM}()},
\code{\link{convertToMinutes}()},
\code{\link{convertToSeconds}()}

Other conversion: 
\code{\link{convert.magic}()},
\code{\link{convertHoursAMPM}()},
\code{\link{convertToMinutes}()},
\code{\link{convertToSeconds}()},
\code{\link{percentileToTScore}()},
\code{\link{pom}()}
}
\concept{conversion}
\concept{times}
