# This file is automatically generated by data-raw/create_sdtms_data.R.
# For updating it please edit inst/extdata/sdtms-specs.json and rerun create_sdtms_data.R.
# Manual edits are not recommended, as changes may be overwritten.
#' Disease Response (IMWG)
#'
#' A SDTM RS dataset using IMWG criteria intended for examples of ADaM dataset creation
#'
#' @name rs_onco_imwg
#' @title Disease Response (IMWG)
#' @keywords dataset
#' @description A SDTM RS dataset using IMWG criteria intended for examples of ADaM dataset creation
#' @docType data
#' @format A data frame with 17 columns:
#'   \describe{
#'     \item{STUDYID}{Study Identifier}
#'     \item{DOMAIN}{Domain Abbreviation}
#'     \item{USUBJID}{Unique Subject Identifier}
#'     \item{RSSEQ}{Sequence Number}
#'     \item{RSLNKGRP}{Link Group ID}
#'     \item{RSTESTCD}{Assessment Short Name}
#'     \item{RSTEST}{Assessment Name}
#'     \item{RSCAT}{Category for Assessment}
#'     \item{RSORRES}{Result or Finding in Original Units}
#'     \item{RSSTRESC}{Character Result/Finding in Std Format}
#'     \item{RSSTAT}{Completion Status}
#'     \item{RSREASND}{Reason Not Done}
#'     \item{RSEVAL}{Evaluator}
#'     \item{VISITNUM}{Visit Number}
#'     \item{VISIT}{Visit Name}
#'     \item{RSDTC}{Date/Time of Assessment}
#'     \item{RSDY}{Study Day of Assessment}
#'   }
#'
#' @source Derived from tr_onco_recist
#' @author Vinh Nguyen
#' @details Contains a set of 1 unique Test Short Name and Test Name: \tabular{ll}{
#'   \strong{RSTESTCD} \tab \strong{RSTEST} \cr
#'   OVRLRESP \tab Overall Response
#' }

"rs_onco_imwg"
