% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download-db.R
\name{download_searchindex}
\alias{download_searchindex}
\title{Download search index}
\usage{
download_searchindex(
  country,
  path = tempdir(),
  date = "latest",
  exact = FALSE,
  section = NULL,
  only_url = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{country}{Character string that can be identified by
\code{\link[countrycode]{countryname}} as a country. An extract for this
country will be downloaded. If \code{"planet"}, downloads a global search
index (see note).}

\item{path}{Path to a directory where the identified file should be stored.
Defaults to \code{tempdir()}.}

\item{date}{Character string or date-time object used to specify the creation
date of the search index. If \code{"latest"}, will download the file tagged
with "latest". If a character string, the value should be parseable by
\code{\link{as.POSIXct}}. If \code{exact = FALSE}, the input value is
compared to all available dates and the closest date will be selected.
Otherwise, a file will be selected that exactly matches the input to
\code{date}.}

\item{exact}{If \code{TRUE}, exactly matches the \code{date}. Otherwise,
selects the date with lowest difference to the \code{date} parameter.}

\item{section}{Subdirectory of the download server from which to select a
search index. If \code{"experimental"}, selects a dump made for the master
version of photon. If \code{"archived"}, selects a dump made for an older
version of photon. If \code{NULL} (or any arbitrary string), selects a
dump made for the current release. Defaults to \code{NULL}.}

\item{only_url}{If \code{TRUE}, performs a download. Otherwise,
only returns a link to the file.}

\item{quiet}{If \code{TRUE}, suppresses all informative messages.}
}
\value{
If \code{only_url = FALSE}, returns the local path to the downloaded
file. Otherwise, returns the URL to the remote file.
}
\description{
Finds and downloads the OpenSearch index database necessary to set up
Photon locally.
}
\note{
Depending on the country, search index databases tend to be very large.
The global search index is about 75 GB of size (10/2024). Keep that in mind
when running this function.
}
\section{Limitations}{

The index download depends on a public repository
(\url{https://download1.graphhopper.com/public/}). This repository only
hosts search indices for the latest stable and experimental versions and
is thus not suitable for reproducibility. If you wish to make a project
reproducible, consider storing the search index somewhere persistent.
Photon is generally not backwards-compatible and newer versions of Photon
are not guaranteed to work with older search indices (based on personal
experience).

Additionally, this function can only download pre-built search indices
from country extracts. If you need a more fine-grained scope or a combination
of multiple countries, you need to build your own search index. See
\code{vignette("nominatim-import", package = "photon")}.
}

\examples{
\donttest{# download the latest extract of Monaco
download_searchindex("Monaco", path = tempdir())

# download the latest extract of American Samoa
download_searchindex(path = tempdir(), section = NULL, country = "Samoa")

# download an extract from a month ago
try(download_searchindex(
  path = tempdir(),
  country = "Monaco",
  date = Sys.time() - 2629800
))

# if possible, download an extract from today
try(download_searchindex(
  path = tempdir(),
  country = "Monaco",
  date = Sys.Date(),
  exact = TRUE
))}

# get the latest global coverage
# NOTE: the file to be downloaded is several tens of gigabytes of size!
\dontrun{
download_searchindex(path = tempdir(), country = "planet")}
}
