% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{clear_pliman_cache}
\alias{clear_pliman_cache}
\title{Clear cached files created by pliman}
\usage{
clear_pliman_cache(all = TRUE, days = NULL)
}
\arguments{
\item{all}{Logical. If \code{TRUE} (default), deletes the entire cache directory.}

\item{days}{Integer (optional). If provided, removes only files older than
\code{days}. Ignored if \code{all = TRUE}.}
}
\value{
Invisibly returns \code{TRUE} if the operation was successful.
}
\description{
Deletes cached \code{.rds} files used by functions such as \code{\link[=object_scatter]{object_scatter()}}.
You can either remove the entire cache directory or only files older
than a given number of days.
}
\examples{
if(interactive()){
# Clear everything
clear_pliman_cache()

# Clear only files older than 7 days
clear_pliman_cache(all = FALSE, days = 7)
}

}
