% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mapedit.R
\name{image_view}
\alias{image_view}
\title{Create an interactive map view of an image}
\usage{
image_view(
  img,
  object = NULL,
  r = 1,
  g = 2,
  b = 3,
  edit = FALSE,
  alpha = 0.7,
  attribute = "area",
  title = "Edit the image",
  show = c("rgb", "index"),
  index = "B",
  max_pixels = 1e+06,
  downsample = NULL,
  color_regions = custom_palette(),
  quantiles = c(0, 1),
  ...
)
}
\arguments{
\item{img}{An \code{Image} object.}

\item{object}{(Optional). An object computed with \code{\link[=analyze_objects]{analyze_objects()}}. If an
object is informed, an additional layer is added to the plot, showing the
contour of the analyzed objects, with a color gradient defined by
\code{attribute}.}

\item{r, g, b}{The layer for the Red, Green and Blue band, respectively.
Defaults to \code{1}, \code{2}, and \code{3}.}

\item{edit}{If \code{TRUE} enable editing options using \code{\link[mapedit:editMap]{mapedit::editMap()}}.}

\item{alpha}{The transparency level of the rectangles' color (between 0 and 1).}

\item{attribute}{The name of the quantitative variable in the
\code{object_index} to be used for coloring the rectangles.}

\item{title}{The title of the map view. Use to provide short orientations to
the user.}

\item{show}{The display option for the map view. Options are "rgb" for RGB
view and "index" for index view.}

\item{index}{The index to use for the index view. Defaults to "B".}

\item{max_pixels}{integer > 0. Maximum number of cells to use for the plot.
If \code{max_pixels < npixels(img)}, regular sampling is used before plotting.}

\item{downsample}{integer; for each dimension the number of
pixels/lines/bands etc that will be skipped; Defaults to \code{NULL}, which will
find the best downsampling factor to approximate the \code{max_pixels} value.}

\item{color_regions}{The color palette for displaying index values. Default
is \code{\link[=custom_palette]{custom_palette()}}.}

\item{quantiles}{the upper and lower quantiles used for color stretching. Set
to \code{c(0, 1)}}

\item{...}{Additional arguments to be passed to \code{downsample_fun}.}
}
\value{
An \code{sf} object, the same object returned by \code{\link[mapedit:editMap]{mapedit::editMap()}}.
}
\description{
This function allows users to interactively edit and analyze an image using
mapview and mapedit packages.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
# Example usage:
img <- image_pliman("sev_leaf.jpg")
image_view(img)
}

}
