% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_input}
\alias{mosaic_input}
\alias{mosaic_export}
\title{Create and Export mosaics}
\usage{
mosaic_input(
  mosaic,
  mosaic_pattern = NULL,
  info = TRUE,
  check_16bits = FALSE,
  check_datatype = FALSE,
  ...
)

mosaic_export(mosaic, filename, datatype = NULL, overwrite = FALSE, ...)
}
\arguments{
\item{mosaic}{\itemize{
\item For \code{mosaic_input()}, a file path to the raster to imported, a matrix,
array or a list of \code{SpatRaster} objects.
\item For \code{mosaic_export()}, an \code{SpatRaster} object.
}}

\item{mosaic_pattern}{A pattern name to import multiple mosaics into a list.}

\item{info}{Print the mosaic informations (eg., CRS, extent). Defaults to \code{TRUE}}

\item{check_16bits}{Checks if mosaic has maximum value in the 16-bits format
(65535), and replaces it by NA. Defaults to \code{FALSE}.}

\item{check_datatype}{Logical. If \code{TRUE}, checks and suggests the
appropriate data type based on the raster values.}

\item{...}{Additional arguments passed to \code{\link[terra:rast]{terra::rast()}} (\code{mosaic_input()})
or  \code{\link[terra:writeRaster]{terra::writeRaster()}} (\code{mosaic_output()})}

\item{filename}{character. The Output filename.}

\item{datatype}{The datatype. By default, the function will try to guess the
data type that saves more memory usage and file size. See
\code{\link[terra:writeRaster]{terra::writeRaster()}} and \code{\link[terra:datatype]{terra::datatype()}} for more details.}

\item{overwrite}{logical. If \code{TRUE}, filename is overwritten.}
}
\value{
\itemize{
\item \code{mosaic_input()} returns an \code{SpatRaster} object.
\item \code{mosaic_export()} do not return an object.
}
}
\description{
Create and Export mosaics
}
\details{
\itemize{
\item \code{mosaic_input()} is a simply wrapper around \code{\link[terra:rast]{terra::rast()}}. It creates a
\code{SpatRaster} object from scratch, from a filename, or from another object.
\item \code{mosaic_export()} is a simply wrapper around \code{\link[terra:writeRaster]{terra::writeRaster()}}. It write
a \code{SpatRaster} object to a file.
}
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)

# create an SpatRaster object based on a matrix
x <- system.file("ex/logo.tif", package="terra")
rast <- mosaic_input(x)
mosaic_plot(rast)

# create a temporary filename for the example
f <- file.path(tempdir(), "test.tif")
mosaic_export(rast, f, overwrite=TRUE)
list.files(tempdir())
}

}
