% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shp.R
\name{object_split_shp}
\alias{object_split_shp}
\title{Splits image objects based on a shape file}
\usage{
object_split_shp(
  img,
  nrow = 1,
  ncol = 1,
  buffer_x = 0,
  buffer_y = 0,
  interactive = FALSE,
  viewer = get_pliman_viewer(),
  only_shp = FALSE,
  ...
)
}
\arguments{
\item{img}{An object of class \code{Image}}

\item{nrow}{The number of desired rows in the grid. Defaults to \code{1}.}

\item{ncol}{The number of desired columns in the grid. Defaults to \code{1}.}

\item{buffer_x, buffer_y}{Buffering factor for the width and height,
respectively, of each individual shape's side. A value between 0 and 0.5 where 0
means no buffering and 0.5 means complete buffering (default: 0). A value of
0.25 will buffer the shape by 25\% on each side.}

\item{interactive}{If \code{FALSE} (default) the grid is created automatically
based on the image dimension and number of rows/columns. If \code{interactive = TRUE}, users must draw points at the diagonal of the desired bounding box
that will contain the grid.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are \code{"base"} and
\code{"mapview"}. If set to "base", the base R graphics system is used for
interactive plotting. If set to "mapview", the mapview package is used. To
set this argument globally for all functions in the package, you can use
the \code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{only_shp}{If \code{TRUE} returns only the shapefiles with the coordinates
for each image. If \code{FALSE} (default) returns the splitted image according
to \code{nrow} and \code{ncol} arguments.}

\item{...}{Other arguments passed on to \code{\link[=image_shp]{image_shp()}}}
}
\value{
A list of \code{Image} objects
}
\description{
Here, \code{\link[=image_shp]{image_shp()}} is used to create a shape file based on the desired
number of rows and columns. Then, using the object coordinates, a list of
\code{Image} objects is created.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
flax <- image_pliman("flax_leaves.jpg", plot = TRUE)
objects <- object_split_shp(flax, nrow = 3, ncol = 5)
image_combine(objects$imgs)
}
}
