% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sad.R
\name{sad}
\alias{sad}
\title{Produces Santandard Area Diagrams}
\usage{
sad(
  object,
  n,
  show_original = FALSE,
  show_contour = FALSE,
  nrow = NULL,
  ncol = NULL,
  ...
)
}
\arguments{
\item{object}{An object computed with \code{\link[=measure_disease]{measure_disease()}} or
\code{\link[=measure_disease_byl]{measure_disease_byl()}}.}

\item{n}{The number of leaves in the Standard Area Diagram.}

\item{show_original}{Show original images? Defaults to \code{FALSE}, i.e., a mask
is returned.}

\item{show_contour}{Show original images? Defaults to \code{FALSE}, i.e., a mask
is returned.}

\item{nrow, ncol}{The number of rows and columns in the plot. See
[image_combine())]

[image_combine())]: R:image_combine())}

\item{...}{Other arguments passed on to \code{\link[=measure_disease]{measure_disease()}}.}
}
\value{
A data frame with the severity values for the \code{n} sampled leaves. A plot with
the standard area diagram can be saved by wrapping \code{\link[=sad]{sad()}} with \code{\link[=png]{png()}}.
}
\description{
Given an object computed with \code{\link[=measure_disease]{measure_disease()}} or \code{\link[=measure_disease_byl]{measure_disease_byl()}}
a Standard Area Diagram (SAD) with \code{n} images are returned with the
respective severity values.
}
\details{
The leaves with the smallest and highest severity will always be in the SAD.
If \code{n = 1}, the leaf with the smallest severity will be returned. The others
are sampled sequentially to achieve the \code{n} images after severity has been
ordered in an ascending order. For example, if there are 30 leaves and n is
set to 3, the leaves sampled will be the 1st, 15th, and 30th with the
smallest severity values.

The SAD can be only computed if an image pattern name is used in argument
\code{pattern} of \code{\link[=measure_disease]{measure_disease()}}. If the images are saved, the \code{n} images
will be retrevied from \code{dir_processed} directory. Otherwise, the severity
will be computed again to generate the images.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
sev <-
measure_disease(pattern = "sev_leaf",
                img_healthy = "sev_healthy",
                img_symptoms = "sev_sympt",
                img_background  = "sev_back",
                plot = FALSE,
                save_image = TRUE,
                show_original = FALSE,
                dir_original = image_pliman(),
                dir_processed = tempdir())
sad(sev, n = 2)
}
}
\references{
Del Ponte EM, Pethybridge SJ, Bock CH, et al (2017) Standard area
diagrams for aiding severity estimation: Scientometrics, pathosystems, and
methodological trends in the last 25 years. Phytopathology 107:1161–1174.
\doi{10.1094/PHYTO-02-17-0069-FI}
}
