% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{utils_colorspace}
\alias{utils_colorspace}
\alias{rgb_to_hsb}
\alias{rgb_to_srgb}
\alias{rgb_to_lab}
\title{Convert between colour spaces}
\usage{
rgb_to_hsb(object)

rgb_to_srgb(object)

rgb_to_lab(object)
}
\arguments{
\item{object}{An \code{Image} object, an object computed with \code{analyze_objects()}
with a valid \code{object_index} argument, or a \code{data.frame/matrix}. For the
last, a three-column data (R, G, and B, respectively) is required.}
}
\value{
A data frame with the columns of the converted color space
}
\description{
\itemize{
\item \code{rgb_to_srgb()} Transforms colors from RGB space (red/green/blue) to
Standard Red Green Blue (sRGB), using a gamma correction of 2.2. The
function performs the conversion by applying a gamma correction to the input
RGB values (raising them to the power of 2.2) and then transforming them
using a specific transformation matrix. The result is clamped to the range
0-1 to ensure valid sRGB values.
\item \code{rgb_to_hsb()} Transforms colors from RGB space (red/green/blue) to HSB
space (hue/saturation/brightness). The HSB values are calculated as follows
(see https://www.rapidtables.com/convert/color/rgb-to-hsv.html for more
details).
\itemize{
\item Hue: The hue is determined based on the maximum value among R, G, and B,
and it ranges from 0 to 360 degrees.
\item Saturation: Saturation is calculated as the difference between the maximum
and minimum channel values, expressed as a percentage.
\item Brightness: Brightness is equal to the maximum channel value, expressed as
a percentage.
}
\item \code{rgb_to_lab()} Transforms colors from RGB space (red/green/blue) to CIE-LAB
space, using the sRGB values. See \code{\link[grDevices:convertColor]{grDevices::convertColor()}} for more
details.
}
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
img <- image_pliman("sev_leaf.jpg")
rgb_to_lab(img)

# analyze the object and convert the pixels
anal <- analyze_objects(img, object_index = "B", pixel_level_index = TRUE)
rgb_to_lab(anal)
}
}
\references{
See \href{https://www.example.com}{the detailed formulas here}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
