% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betabinom.R
\name{betabinomial}
\alias{betabinomial}
\alias{rbetabinom}
\alias{dbetabinom}
\title{Beta-binomial distribution}
\usage{
rbetabinom(n = 1, size, prob, theta)

dbetabinom(x, size, prob, theta, log = FALSE)
}
\arguments{
\item{n}{integer; number of random variates to generate.}

\item{size}{\code{size} parameter of the binomial distribution}

\item{prob}{mean of the Beta distribution}

\item{theta}{Beta distribution dispersion parameter}

\item{x}{vector of non-negative integer quantiles}

\item{log}{logical; if TRUE, return logarithm(s) of probabilities.}
}
\value{
\item{rbetabinom}{
   Returns a vector of length \code{n} containing random variates drawn from the Beta-binomial distribution.
}
\item{dbetabinom}{
   Returns a vector (of length equal to the number of columns of \code{x}) containing the probabilities of observing each column of \code{x} given the specified parameters (\code{size}, \code{prob}, \code{theta}).
}
}
\description{
Density and random generation for the Beta-binomial distribution with parameters \code{size}, \code{mu}, and \code{theta}.
}
\details{
A variable \eqn{X} is Beta-binomially distributed if
\eqn{X\sim{\mathrm{Binomial}(n,P)}}{X~{Binomial(n,P)}} where \eqn{P\sim{\mathrm{Beta}(\mu,\theta)}}{P~Beta(mu,theta)}.
Using the standard \eqn{(a,b)} parameterization, \eqn{a=\mu\,\theta}{a=mu*theta} and \eqn{b=(1-\mu)\,\theta}{b=(1-mu)*theta}.
}
\section{C API}{

An interface for C codes using these functions is provided by the package.
Visit the package homepage to view the \href{https://kingaa.github.io/pomp/C_API.html}{\pkg{pomp} C API document}.
}

\seealso{
More on implementing POMP models:
\code{\link{Csnippet}},
\code{\link{accumvars}},
\code{\link{basic_components}},
\code{\link{covariates}},
\code{\link{dinit_spec}},
\code{\link{dmeasure_spec}},
\code{\link{dprocess_spec}},
\code{\link{emeasure_spec}},
\code{\link{eulermultinom}},
\code{\link{parameter_trans}()},
\code{\link{pomp-package}},
\code{\link{pomp_constructor}},
\code{\link{prior_spec}},
\code{\link{rinit_spec}},
\code{\link{rmeasure_spec}},
\code{\link{rprocess_spec}},
\code{\link{skeleton_spec}},
\code{\link{transformations}},
\code{\link{userdata}},
\code{\link{vmeasure_spec}}
}
\concept{implementation information}
\concept{probability distributions}
