% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmeasure_spec.R
\name{rmeasure_spec}
\alias{rmeasure_spec}
\title{rmeasure specification}
\description{
Specification of the measurement-model simulator, rmeasure.
}
\details{
The measurement model is the link between the data and the unobserved state process.
It can be specified either by using one or both of the \code{rmeasure} and \code{dmeasure} arguments.

Suppose you have a procedure to simulate observations given the value of the latent state variables.
Then you can furnish \preformatted{
  rmeasure = f}
to \pkg{pomp} algorithms,
where \code{f} is a C snippet or \R function that implements your procedure.

Using a C snippet is much preferred, due to its much greater computational efficiency.
See \code{\link{Csnippet}} for general rules on writing C snippets.

In writing an \code{rmeasure} C snippet, bear in mind that:
  \enumerate{
    \item The goal of such a snippet is to fill the observables with random values drawn from the measurement model distribution.
    Accordingly, each observable should be assigned a new value.
    \item In addition to the states, parameters, and covariates (if any), the variable \code{t}, containing the time of the observation, will be defined in the context in which the snippet is executed.
  }

The demos and the tutorials on the \href{https://kingaa.github.io/pomp/}{package website} give examples.

It is also possible, though far less efficient, to specify \code{rmeasure} using an \R function.
In this case, specify the measurement model simulator by furnishing \preformatted{
  rmeasure = f}
to \code{pomp}, where \code{f} is an \R function.
The arguments of \code{f} should be chosen from among the state variables, parameters, covariates, and time.
It must also have the argument \code{...}.
\code{f} must return a named numeric vector of length equal to the number of observable variables.
}
\section{Default behavior}{

The default \code{rmeasure} is undefined.
It will yield missing values (\code{NA}).
}

\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{\link[=pomp]{cdir}} and \code{\link[=pomp]{cfile}} options to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\examples{
\donttest{
  ## We start with the pre-built Ricker example:
  
  ricker() -> po

  ## To change the measurement model simulator, rmeasure,
  ## we use the 'rmeasure' argument in any 'pomp'
  ## elementary or estimation function.
  ## Here, we pass the rmeasure specification to 'simulate'
  ## as an R function.

  po |>
    simulate(
      rmeasure=function (N, phi, ...) {
        c(y=rpois(n=1,lambda=phi*N))
      }
    ) -> sim

  ## We can also pass it as a C snippet:

  po |>
    simulate(
      rmeasure=Csnippet("y = rpois(phi*N);"),
      paramnames="phi",
      statenames="N"
    ) -> sim

}
}
\seealso{
\code{\link{rmeasure}}

More on implementing POMP models:
\code{\link{Csnippet}},
\code{\link{accumvars}},
\code{\link{basic_components}},
\code{\link{betabinomial}},
\code{\link{covariates}},
\code{\link{dinit_spec}},
\code{\link{dmeasure_spec}},
\code{\link{dprocess_spec}},
\code{\link{emeasure_spec}},
\code{\link{eulermultinom}},
\code{\link{parameter_trans}()},
\code{\link{pomp-package}},
\code{\link{pomp_constructor}},
\code{\link{prior_spec}},
\code{\link{rinit_spec}},
\code{\link{rprocess_spec}},
\code{\link{skeleton_spec}},
\code{\link{transformations}},
\code{\link{userdata}},
\code{\link{vmeasure_spec}}
}
\concept{implementation information}
