% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{oxford_comma}
\alias{oxford_comma}
\title{Character Vector To List Phrase With Oxford Comma}
\usage{
oxford_comma(chr, sep = ", ", final = "or")
}
\arguments{
\item{chr}{A character vector to turn into a list phrase (e.g. c("a", "b", "c")).}

\item{sep}{Separator symbols used to separate the elements in the
character vector, Default: ', '}

\item{final}{String to use in place of the final separator when we have
at least two elements in the character vector, Default: 'or'.}
}
\value{
A string in the form of a list that has a comma if
there are at least three elements in the list (e.g. "a, b, or c")
}
\description{
A function that converts a character vector into a list phrase that
uses the Oxford comma.
}
\examples{
oxford_comma(c("James", "John", "Jeremy"))

oxford_comma(c("James", "John", "Jeremy"), final = "and")

oxford_comma(c("James", "John"))

oxford_comma(c("James"))
}
