% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.projoint_results.R
\name{plot.projoint_results}
\alias{plot.projoint_results}
\title{Plot method for \code{projoint_results}}
\usage{
\method{plot}{projoint_results}(
  x,
  .estimates = "corrected",
  .by_var = FALSE,
  .labels = NULL,
  .base_size = 12,
  .base_family = "",
  .type = c("bar", "pointrange"),
  .show_attribute = TRUE,
  .remove_xaxis = FALSE,
  .xlim = c(0, 1),
  .plot.margin = c(0, 3, 0, 3),
  ...
)
}
\arguments{
\item{x}{A \code{projoint_results} object (typically from \code{\link{projoint}}).}

\item{.estimates}{Character: which estimates to plot. One of
\code{"corrected"}, \code{"uncorrected"}, or \code{"both"} (for profile-level),
and \code{"corrected"} or \code{"uncorrected"} (for choice-level). Default \code{"corrected"}.}

\item{.by_var}{Logical (profile-level only). Whether to plot subgroup differences.
Default \code{FALSE}.}

\item{.labels}{Character vector of length 2 (choice-level only). Custom x-axis
labels for bar/pointrange plots. If \code{NULL}, labels are taken from \code{x$labels}.}

\item{.base_size}{Numeric. Base font size. Default \code{12}.}

\item{.base_family}{Character. Base font family. Default \code{""} (system default).}

\item{.type}{Character (choice-level only). One of \code{"bar"} or \code{"pointrange"}.
Default \code{"bar"}.}

\item{.show_attribute}{Logical (choice-level only). Show the attribute name as the
title when both levels belong to the same attribute. Default \code{TRUE}.}

\item{.remove_xaxis}{Logical (choice-level only). Remove x-axis line, ticks, and labels.
Default \code{FALSE}.}

\item{.xlim}{Numeric length-2 vector (choice-level only). X-axis limits. Default \code{c(0, 1)}.}

\item{.plot.margin}{Numeric length-4 vector (choice-level only). Plot margins in cm:
\code{c(top, left, bottom, right)}. Default \code{c(0, 3, 0, 3)}.}

\item{...}{Additional arguments passed to downstream plotting helpers.}
}
\value{
A \code{ggplot2} object.
}
\description{
Creates publication-ready plots from a \code{projoint_results} object produced by
\code{\link{projoint}}. Supports both profile-level and choice-level analyses,
with plotting options tailored to each structure.
}
\details{
For profile-level results, only \code{.by_var}, \code{.base_size}, and \code{.base_family}
are relevant. For choice-level results, only \code{.type}, \code{.labels},
\code{.show_attribute}, \code{.remove_xaxis}, \code{.xlim}, and \code{.plot.margin}
are relevant. Irrelevant arguments are ignored with a warning.
}
\examples{
\donttest{
data(exampleData1)

# Two base tasks (1 & 2) + repeated of task 1 (last)
dat <- reshape_projoint(
  exampleData1,
  .outcomes = c("choice1", "choice2", "choice1_repeated_flipped")
)

# Build a valid QOI from the labels
att <- unique(dat$labels$attribute_id)[1]
levs <- subset(dat$labels, attribute_id == att)$level_id
lev_names <- sub(".*:", "", levs)

q <- set_qoi(
  .structure     = "choice_level",
  .estimand      = "mm",
  .att_choose    = att,
  .lev_choose    = lev_names[2],
  .att_notchoose = att,
  .lev_notchoose = lev_names[1]
)

fit <- projoint(dat, .qoi = q)

# Plot method
plot(fit)
}
}
\seealso{
\code{\link{projoint}}, \code{plot_projoint_profile_level},
  \code{\link{plot_projoint_choice_level_mm}}
}
