% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if_else.R
\name{if_else}
\alias{if_else}
\alias{if.}
\alias{else_if.}
\alias{else.}
\title{If - Else if - Else Statements}
\usage{
if.(data_frame, condition, ...)

else_if.(data_frame, condition, ...)

else.(data_frame, ...)
}
\arguments{
\item{data_frame}{A data frame on which to apply an if statement.}

\item{condition}{The condition on which a value should be passed to a variable.}

\item{...}{The Assignment of what should happen when condition becomes TRUE.}
}
\value{
Returns a data frame with conditionally computed variables. If assigned values
are of different types a character variable will be returned.
}
\description{
These functions make if statements more readable. Especially if an if block becomes bigger
it can be hard to read with multiple nested if_else statements. With these new functions
if blocks can be written like in other languages with a clear and simpler structure. In
addition not only for one variable can a new value be assigned, but for multiple.

\code{\link[=if.]{if.()}} always creates a new variable if the given variable name is not part of the given
data frame. If there already is a variable with the given name, the existing values will
be overwritten if the condition is TRUE.

If no new variable is provided, \code{\link[=if.]{if.()}} will select observations by the given condition
instead.

\code{\link[=else_if.]{else_if.()}} only acts if there already is a variable with the given name. Only NA values
will get new values if condition is TRUE. The existing values will not be overwritten.

\code{\link[=else.]{else.()}} only acts if there already is a variable with the given name. Sets every
remaining NA in given variable to the given value.
}
\examples{
# Example data frame
my_data <- dummy_data(1000)

# Call function
new_df <- my_data |>
         if.(age < 18,             age_group = "under 18") |>
    else_if.(age >= 18 & age < 65, age_group = "18 to under 65") |>
    else.   (                      age_group = "65 and older")

# Or with multiple variables
new_df <- my_data |>
         if.(age < 18,             age_group = "under 18"      , age_num = 1L) |>
    else_if.(age >= 18 & age < 65, age_group = "18 to under 65", age_num = 2L) |>
    else.   (                      age_group = "65 and older",   age_num = 3L)

# NOTE: As in other languages the following if blocks won't produce the same result.
#       if.() will overwrite existing values, while else_if.() will not.
state_df <- my_data |>
         if.(state == 1, state_a = "State 1") |>
    else_if.(state < 11, state_a = "West") |>
    else.   (            state_a = "East")

state_df <- state_df |>
      if.(state == 1, state_b = "State 1") |>
      if.(state < 11, state_b = "West") |>
    else.(            state_b = "East")

# Select observations by condition instead of generating new variable
subset_df <- my_data |> if.(sex == 1)

}
\keyword{internal}
