% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reptools.r
\name{htmlView}
\alias{htmlView}
\title{htmlView}
\usage{
htmlView(...)
}
\arguments{
\item{...}{any number of objects for which an \code{html} method exists}
}
\value{
nothing is returned; used to launch a browser on html text
}
\description{
Convert Objects to HTML and View
}
\details{
Converts a series of objects created to html.
Displays these in the RStudio View pane.
If RStudio is not running displays in an external browser.
Assumes there is an \code{html} method for the objects (e.g., objects
are result of \code{Hmisc::describe} or \code{Hmisc::contents}.
User can page through the different outputs with the arrow keys
in the RStudio View pane
}
\examples{
\dontrun{
 htmlView(contents(d1), contents(d2))
 htmlView(describe(d1), describe(d2, descript='Second Dataset'))
 htmlView(contents(d), describe(d))
}
}
\author{
Frank Harrell
}
