% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psymet_functions.R
\name{confint2.default}
\alias{confint2.default}
\title{Confidence Intervals from Parameter Estimates and Standard Errors}
\usage{
\method{confint2}{default}(obj, se, df = Inf, level = 0.95, ...)
}
\arguments{
\item{obj}{numeric vector of parameter estimates. A better name for this
argument would be \code{est}; however, uses of S3 generic functions requires
the first argument to be the same name (i.e., \code{obj}) across methods.}

\item{se}{numeric vector of standard errors. Must be the same length as
\code{obj}.}

\item{df}{numeric vector of degrees of freedom. Must have length 1 or the
same length as \code{obj} and \code{se}. If degrees of freedom are not
applicable or available, then \code{df} can be set to \code{Inf} (the
default) and critical z-values rather than critical t-values will be used.}

\item{level}{double vector of length 1 specifying the confidence level. Must
be between 0 and 1.}

\item{...}{This argument has no use. Technically, it is additional arguments
for \code{confint2.default}, but is only included for Roxygen2 to satisfy
"checking S3 generic/method consistency".}
}
\value{
data.frame with nrow equal to the lengths of \code{obj} and
\code{se}. The rownames are taken from \code{obj}, unless \code{obj} does not
have any names and then the rownames are taken from the names of \code{se}.
If neither have names, then the rownames are automatic (i.e.,
\code{1:nrow()}). The columns are the following:

\describe{
   \item{est}{parameter estimates}
   \item{se}{standard errors}
   \item{lwr}{lower bound of the confidence intervals}
   \item{upr}{upper bound of the confidence intervals}
}
}
\description{
\code{confint2.default} is the default method for the generic function
\code{\link{confint2}} and computes the statistical information for confidence
intervals from parameter estimates, standard errors, and degrees of freedom.
If degrees of freedom are not applicable or available, then \code{df} can be
set to \code{Inf} (the default) and critical z-values rather than critical
t-values will be used.
}
\examples{

# single estimate
confint2.default(obj = 10, se = 3)

# multiple estimates
est <- colMeans(attitude)
se <- apply(X = str2str::d2m(attitude), MARGIN = 2, FUN = function(vec)
   sqrt(var(vec) / length(vec)))
df <- nrow(attitude) - 1
confint2.default(obj = est, se = se, df = df)
confint2.default(obj = est, se = se) # default is df = Inf and use of ctitical z-values
confint2.default(obj = est, se = se, df = df, level = 0.99)

# error
\dontrun{
confint2.default(obj = c(10, 12), se = c(3, 4, 5))
}

}
\seealso{
\code{\link{confint2.boot}}
   \code{\link{nhst}}
}
