% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ena.R
\name{ena}
\alias{ena}
\title{Wrapper to generate, and optionally plot, an ENA model}
\usage{
ena(
  data,
  codes,
  units,
  conversation,
  metadata = NULL,
  model = c("EndPoint", "AccumulatedTrajectory", "SeparateTrajectory"),
  weight.by = "binary",
  window = c("MovingStanzaWindow", "Conversation"),
  window.size.back = 1,
  include.meta = TRUE,
  groupVar = NULL,
  groups = NULL,
  runTest = FALSE,
  points = FALSE,
  mean = FALSE,
  network = TRUE,
  networkMultiplier = 1,
  subtractionMultiplier = 1,
  unit = NULL,
  include.plots = T,
  print.plots = F,
  ...
)
}
\arguments{
\item{data}{data.frame with containing metadata and coded columns}

\item{codes}{vector, numeric or character, of columns with codes}

\item{units}{vector, numeric or character, of columns representing units}

\item{conversation}{vector, numeric or character, of columns to segment conversations by}

\item{metadata}{vector, numeric or character, of columns with additional meta information for units}

\item{model}{character: EndPoint (default), AccumulatedTrajectory, SeparateTrajectory}

\item{weight.by}{"binary" is default, can supply a function to call (e.g. sum)}

\item{window}{MovingStanzaWindow (default) or Conversation}

\item{window.size.back}{Number of lines in the stanza window (default: 1)}

\item{include.meta}{[TBD]}

\item{groupVar}{vector, character, of column name containing group identifiers.
If column contains at least two unique values, will generate model using a means rotation (a dimensional reduction maximizing the variance between the means of the two groups)}

\item{groups}{vector, character, of values of groupVar column used for means rotation, plotting, or statistical tests}

\item{runTest}{logical, TRUE will run a Student's t-Test and a Wilcoxon test for groups defined by the groups argument}

\item{points}{logical, TRUE will plot points (default: FALSE)}

\item{mean}{logical, TRUE will plot the mean position of the groups defined in the groups argument (default: FALSE)}

\item{network}{logical, TRUE will plot networks (default: TRUE)}

\item{networkMultiplier}{numeric, scaling factor for non-subtracted networks (default: 1)}

\item{subtractionMultiplier}{numeric, scaling factor for subtracted networks (default: 1)}

\item{unit}{vector, character, name of a single unit to plot}

\item{include.plots}{logical, TRUE will generate plots based on the model (default: TRUE)}

\item{print.plots}{logical, TRUE will show plots in the Viewer(default: FALSE)}

\item{...}{Additional parameters passed to set creation and plotting functions}
}
\value{
ena.set object
}
\description{
Generates an ENA model by constructing a dimensional reduction
of adjacency (co-occurrence) vectors as defined by the supplied
conversations, units, and codes.
}
\details{
This function generates an ena.set object given a data.frame, units,
conversations, and codes. After accumulating the adjacency (co-occurrence)
vectors, computes a dimensional reduction (projection), and calculates node
positions in the projected ENA space. Returns location of the units in the
projected space, as well as locations for node positions, and normalized
adjacency (co-occurrence) vectors to construct network graphs. Includes options
for returning statistical tests between groups of units, as well as plots of units,
groups, and networks.
}
\examples{
data(RS.data)

rs = ena(
  data = RS.data,
  units = c("UserName","Condition", "GroupName"),
  conversation = c("Condition","GroupName"),
  codes = c('Data',
            'Technical.Constraints',
            'Performance.Parameters',
            'Client.and.Consultant.Requests',
            'Design.Reasoning',
            'Collaboration'),
  window.size.back = 4,
  print.plots = FALSE,
  groupVar = "Condition",
  groups = c("FirstGame", "SecondGame")
)

}
