% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpBathy.R
\name{interpBathy}
\alias{interpBathy}
\title{Interpolate bathymetry}
\usage{
interpBathy(
  outline,
  df,
  x,
  y,
  z,
  zeros = FALSE,
  separation = NULL,
  crsUnits = "dd",
  res = 10,
  method = "IDW",
  fact = NULL,
  nmax = 20,
  idp = 2,
  model = "Sph",
  psill = NULL,
  range = NULL,
  nugget = 0,
  kappa = NULL
)
}
\arguments{
\item{outline}{shapefile outline of a waterbody}

\item{df}{dataframe of coordinates and depths for a given waterbody}

\item{x}{character giving name of longitude column}

\item{y}{character giving name of latitude column}

\item{z}{character giving name of depth column}

\item{zeros}{logical describing if bounding zeros are needed (FALSE) or provided (TRUE), default = FALSE}

\item{separation}{number describing distance between points, units from CRS}

\item{crsUnits}{character describing CRS units of input outline, either "dd" (decimal degrees) or "m" (meters), default = "dd"}

\item{res}{number describing desired cell resolution in meters, default = 10}

\item{method}{character describing method of interpolation, options include Inverse Distance Weighted ("IDW") or Ordinary Kriging ("OK"). Default = "IDW"}

\item{fact}{numeric value describing the factor by which raster resolution should be increased, default = NULL If 'crsUnits' and 'res' are defined, fact = NULL}

\item{nmax}{numeric value describing number of neighbors used in interpolation, default = 20}

\item{idp}{numeric value describing inverse distance power value for IDW interpolation}

\item{model}{character describing type of model used in Ordinary Kriging, options include 'Sph', 'Exp', 'Gau', 'Sta', default = 'Sph'}

\item{psill}{numeric value describing the partial sill value for OK interpolation, default = NULL}

\item{range}{numeric describing distance beyond which there is no spatial correlation in Ordinary Kriging models, default = NULL}

\item{nugget}{numeric describing variance at zero distance in Ordinary Kriging models, default = 0}

\item{kappa}{numeric value describing model smoothness, default = NULL}
}
\value{
DEM of waterbody bathymetry
}
\description{
Generate a bathymetric digital elevation model (DEM) for a given waterbody using either Inverse Distance Weighting or Ordinary Kriging interpolation. For high densities of point data, we recommend rarifying prior to interpolation to improve accuracy and reduce computation time (see rarify function).
}
\details{
If 'res' and 'crsUnits' are specified (recommended), the output raster is returned in the original projection at the specified resolution.
If 'res' and 'crsUnits' are not specified, 'fact' must be defined as a numeric value by which the resolution of the output DEM will be increased (1 = no change). Output raster will be returned in the original projection of the input.

For the model argument there are four different methods included here that are supported by gstat::vgm ("Sph", "Exp", "Gau", "Mat").
"Sph" = The default gstat::vgm method. Spherical model characterized by a curve that rises steeply to defined range then flattens, indicates no spatial correlation between points beyond that range.
"Exp" = Exponential model characterized by spatial correlation decaying with distance.
"Gau" = Gaussian model similar to spatial model but with stronger decay at shorter distances.
"Mat" = Matern model
Three parameters (psill, range, kappa) are incorporated from a fitted variogram (default = NULL). If specified in function input, chosen values will overwrite variogram values.

DEMs generated using OK method will have two layers; the first are the interpolated values and the second are the variances associated with each measurement
}
\examples{
\donttest{
#load example outline
outline <- terra::vect(system.file("extdata", "example_outline.shp", package = 'rLakeHabitat'))
#load example xyz data
data <- read.csv(system.file("extdata", "example_depths.csv", package = 'rLakeHabitat'))
#run function
interpBathy(outline, data, "x", "y", "z", zeros = FALSE, separation = 10,
crsUnit = "dd", res = 5, method = "IDW", nmax = 4, idp = 2)}
}
\author{
Tristan Blechinger & Sean Bertalot, Department of Zoology & Physiology, University of Wyoming
}
