% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPublic.R
\name{.rp_make_multileg_payload}
\alias{.rp_make_multileg_payload}
\title{Build Multi-Leg Order Payload (Internal)}
\usage{
.rp_make_multileg_payload(
  orderType,
  qty,
  orderId = NULL,
  leg_symbols,
  leg_types,
  leg_sides,
  leg_indicator,
  leg_ratios,
  lmtPrc = NULL,
  tif,
  expTime = NULL
)
}
\arguments{
\item{orderType}{= (string) The Type of order: 'MARKET', 'LIMIT', 'STOP', 'STOP_LIMIT'}

\item{qty}{= (string) leg_ratio multiple: ex. '2' multiples the leg_ratios by 2X}

\item{orderId}{= (string) The order ID}

\item{leg_symbols}{= (string) Symbols: ex. c("SPY250815C00631000", "SPY250815C00631000")}

\item{leg_types}{= (string) Symbol types: ex. c("OPTION", "OPTION")}

\item{leg_sides}{= (string) The side for each leg: ex. c("BUY", "SELL")}

\item{leg_indicator}{= (string) Indicates if this is BUY to OPEN/CLOSE ex. c("OPEN", "OPEN")}

\item{leg_ratios}{= (string) The number of contracts to BUY/SELL: ex. c('5','5')}

\item{lmtPrc}{= (string) The limit price. Used when orderType = LIMIT or orderType = STOP_LIMIT}

\item{tif}{= (string) The time in for the order: 'DAY' or 'GTD"}

\item{expTime}{= (string) The expiration date. Only used when timeInForce is GTD, cannot be more than 90 days in the future}
}
\value{
Returns an appropriate payload \code{list} for a multiple-leg order
}
\description{
Build Multi-Leg Order Payload (Internal)
}
\examples{
\dontrun{
  # Return the proper order payload for multiple-leg orders
  .rp_make_multileg_payload(orderType="LIMIT", qty="2", orderId=rp_getOrderId(), 
                            leg_symbols = c("SPY250815C00631000", "SPY250815C00631000"), 
                            leg_types = c("OPTION", "OPTION"), leg_sides = c("BUY", "SELL"), 
                            leg_indicator = c("OPEN", "OPEN"), leg_ratios=c('5','5'), 
                            lmtPrc='0.25', tif="DAY")
}
}
