% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BergerParkerP.R
\name{BergerParkerP}
\alias{BergerParkerP}
\title{Calculate Berger-Parker Index on a Matrix}
\usage{
BergerParkerP(x, window = 1, na.tolerance = 1, debugging = FALSE, np = 1)
}
\arguments{
\item{x}{A numeric matrix representing the data on which the index is to be calculated.}

\item{window}{The width of the moving window to consider for each cell. 
The actual window size will be `(2 * window + 1) x (2 * window + 1)`. Default is 1.}

\item{na.tolerance}{The tolerance level for missing data within the moving window. 
A window will be processed only if the proportion of non-missing data is above this threshold. 
Value should be between 0 and 1. Default is 1.}

\item{debugging}{Boolean flag to enable or disable debugging messages. Default is FALSE.}

\item{np}{The number of processes (cores) which will be spawned. Default value is 2.}
}
\value{
A matrix of the same dimensions as `x`, where each cell contains the 
        Berger-Parker Index calculated for the window around the cell.
}
\description{
This function computes Berger-Parker Index for each cell of a matrix, 
using a parallelized approach and considering a specified moving window.
}
\examples{
\dontrun{
data <- matrix(runif(100), nrow = 10)
bp_index <- BergerParkerP(data, window = 1, np=2)
}

}
