% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HillS.R
\name{HillS}
\alias{HillS}
\title{Sequential Hill's diversity index}
\usage{
HillS(x, window = 1, alpha = 1, na.tolerance = 1, debugging = FALSE)
}
\arguments{
\item{x}{Input data.}

\item{window}{Half of the side of the square moving window.}

\item{alpha}{Alpha value for the order of diversity in Hill's Index.}

\item{na.tolerance}{A numeric value between 0.0 and 1.0, which indicates the proportion of NA values that will be tolerated to calculate Hill's index in each moving window over \code{x}. If the relative proportion of NA's in a moving window is greater than na.tolerance, then the value of the window will be set as NA; otherwise, the index will be calculated considering the non-NA values. Default value is 1.0 (i.e., full tolerance for NA's).}

\item{debugging}{A boolean variable set to FALSE by default. If TRUE, additional messages will be printed for debugging purposes.}
}
\value{
Matrix or a list of matrices with the Hill index computed through a moving window of the given size.
}
\description{
Computes Hill's diversity index in a non-parallelized (sequential) manner.
}
\seealso{
\code{\link{Hill}}
}
\author{
Marcantonio Matteo \email{marcantoniomatteo@gmail.com}, Martina Iannacito \email{martina.iannacito@inria.fr}, Duccio Rocchini \email{duccio.rocchini@unibo.it}
}
\keyword{internal}
