% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_dn.R
\name{extract_dn}
\alias{extract_dn}
\title{Extract digital numbers from sky points}
\usage{
extract_dn(r, sky_points, use_window = TRUE)
}
\arguments{
\item{r}{\link[terra:SpatRaster-class]{terra::SpatRaster}. Image from which \code{sky_points} were
sampled (or any raster with identical dimensions).}

\item{sky_points}{\code{data.frame} with columns \code{row} and \code{col} (raster
coordinates).}

\item{use_window}{logical of length one. If \code{TRUE} (default), use a
\eqn{3 \times 3} local mean around each point; if \code{FALSE}, use only the
central pixel.}
}
\value{
\code{data.frame} containing the original \code{sky_points} plus one column per
layer in \code{r} (named after the layers).
}
\description{
Obtain digital numbers from a raster at positions defined by sky points,
with optional local averaging.
}
\details{
Wraps \code{\link[terra:extract]{terra::extract()}} to support a \eqn{3 \times 3} window centered on
each target pixel (local mean). When it is disabled, only the central
pixel value is retrieved.
}
\note{
For instructions on manually digitizing sky points, see the “Digitizing sky
points with ImageJ” and “Digitizing sky points with QGIS” sections in
\code{\link[=fit_cie_model]{fit_cie_model()}}.
}
\examples{
\dontrun{
caim <- read_caim()
r <- caim$Blue
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)

# See fit_cie_model() for details on below file
path <- system.file("external/sky_points.csv",
                    package = "rcaiman")
sky_points <- read.csv(path)
sky_points <- sky_points[c("Y", "X")]
colnames(sky_points) <- c("row", "col")
head(sky_points)
plot(caim$Blue)
points(sky_points$col, nrow(caim) - sky_points$row, col = 2, pch = 10)

sky_points <- extract_dn(caim, sky_points)
head(sky_points)

# To aggregate DNs across points (excluding 'row' and 'col'):
apply(sky_points[, -(1:2)], 2, mean, na.rm = TRUE)
}
}
\seealso{
\code{\link[=extract_sky_points]{extract_sky_points()}}
}
