% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcompendium-package.R
\docType{package}
\name{rcompendium-package}
\alias{rcompendium-package}
\alias{rcompendium}
\title{Create a package or research compendium structure}
\description{
\code{rcompendium} makes easier the creation of R packages or research compendia
(i.e. a predefined files/folders structure) so that users can focus on the
code/analysis instead of wasting time organizing files. A full ready-to-work
structure is set up with some additional features: version control, remote
repository creation, CI/CD configuration (check package integrity under
several OS, test code with 'testthat', and build and deploy website using
'pkgdown').
}
\section{Recommended workflow}{

\enumerate{
\item Store your credentials (given and family names, email, ORCID, etc.) with
\code{\link[=set_credentials]{set_credentials()}} (if not already done);
\item Create an new empty RStudio project;
\item Run \code{\link[=new_package]{new_package()}} to create a new package structure or
\code{\link[=new_compendium]{new_compendium()}} to create a new research compendium structure;
\item Edit some metadata in \code{DESCRIPTION}, \code{CITATION}, and \code{README.Rmd};
\item Start working (add data, write and document R functions, etc.);
\item And do not forget to commit your changes.
}
}

\section{Managing credentials}{


You can use the arguments \code{given}, \code{family}, \code{email}, and \code{orcid}
directly with the functions \verb{new_*()} and \verb{add_*()}. But if you create
a lot a projects (packages and/or compendia) it can be frustrating in the
long run.

An alternative way is to use \strong{ONCE AND FOR ALL} the function
\code{\link[=set_credentials]{set_credentials()}} to permanently store this information in the
\verb{~/.Rprofile} file. If these arguments are set to \code{NULL} while calling any
function of the package, \code{rcompendium} will search their values in this file.
It will save your time (it's the purpose of this package).

Even if you have stored your credentials in the \verb{~/.Rprofile} file you will
always be able to modify them on-the-fly (i.e. by using credentials arguments
in the functions \verb{new_*()} and \verb{add_*()}) or permanently by re-running
\code{\link[=set_credentials]{set_credentials()}}.
}

\section{Configuring git}{


To see if \strong{git} is correctly configured on your laptop, run
\code{\link[gh:gh_whoami]{gh::gh_whoami()}}. You should see something like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{\{
  "name": "John Doe",
  "login": "jdoe",
  "html_url": "https://github.com/jdoe",
  ...
\}
}\if{html}{\out{</div>}}

Otherwise you might need to run:

\if{html}{\out{<div class="sourceCode">}}\preformatted{gert::git_config_global_set(name  = "user.name", 
                            value = "John Doe")
                            
gert::git_config_global_set(name  = "user.email", 
                            value = "john.doe@domain.com")
                            
gert::git_config_global_set(name  = "github.user", 
                            value = "jdoe")
}\if{html}{\out{</div>}}

See \code{\link[gert:git_config]{gert::git_config_global_set()}} for further information.
}

\section{Creating a GitHub repo}{


To create the GitHub repository directly from R, the package \code{rcompendium}
uses the function \code{\link[usethis:use_github]{usethis::use_github()}}, a client to the GitHub REST API.
The interaction with this API required an authentication method: a
\strong{GITHUB PAT} (Personal Access Token).

If you don't have a \strong{GITHUB PAT} locally stored, you must:
\enumerate{
\item Visit the page \url{https://github.com/settings/tokens} and create a new
token;
\item Store it in the \verb{~/.Renviron} file by using \code{\link[usethis:edit]{usethis::edit_r_environ()}}
and adding the following line: \code{GITHUB_PAT='ghp_99z9...z9'}.
}

Run \code{\link[usethis:github-token]{usethis::gh_token_help()}} for more information about getting and
configuring a \strong{GITHUB PAT}.

If everything is well configured, you should see something like this after
calling \code{\link[gh:gh_whoami]{gh::gh_whoami()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{\{
  "name": "John Doe",
  "login": "jdoe",
  "html_url": "https://github.com/jdoe",
  "scopes": "repo, workflow",
  "token": "ghp_...z99Z"
\}
}\if{html}{\out{</div>}}
}

\section{Resources}{

\itemize{
\item Developing an R package:
\url{https://frbcesab.github.io/rcompendium/articles/developing_a_package.html}
\item Working with a compendium:
\url{https://frbcesab.github.io/rcompendium/articles/working_with_a_compendium.html}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/FRBCesab/rcompendium}
  \item \url{https://frbcesab.github.io/rcompendium/}
  \item Report bugs at \url{https://github.com/FRBCesab/rcompendium/issues}
}

}
\author{
\strong{Maintainer}: Nicolas Casajus \email{nicolas.casajus@fondationbiodiversite.fr} (\href{https://orcid.org/0000-0002-5537-5294}{ORCID}) [copyright holder]

}
\keyword{internal}
