% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD.raster}
\alias{readDWD.raster}
\title{read dwd gridded raster data}
\usage{
readDWD.raster(file, gargs = NULL, dividebyten, quiet = rdwdquiet(), ...)
}
\arguments{
\item{file}{Name of file on harddrive, like e.g.
DWDdata/grids_germany/seasonal/air_temperature_mean/
16_DJF_grids_germany_seasonal_air_temp_mean_188216.asc.gz}

\item{gargs}{Named list of arguments passed to \code{\link[R.utils:compressFile]{R.utils::gunzip()}}.
The internal defaults are: \code{remove=FALSE} (recommended to
keep this so \code{file} does not get deleted) and \code{skip=TRUE}
(which reads previously unzipped files as is).
If \code{file} has changed, use \code{gargs=list(temporary=TRUE)}.
The \code{gunzip} default \code{destname} means that the
unzipped file is stored at the same path as \code{file}.
DEFAULT gargs: NULL}

\item{dividebyten}{Logical: Divide the numerical values by 10? See \link{readDWD}.
DEFAULT: TRUE}

\item{quiet}{Ignored.
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[terra:rast]{terra::rast()}}}
}
\value{
\code{\link[terra:rast]{terra::rast}} object
}
\description{
Read gridded raster data.
Intended to be called via \code{\link[=readDWD]{readDWD()}}.\cr
Note that \code{R.utils} must be installed to unzip the .asc.gz files.
}
\examples{
\dontrun{ # Excluded from CRAN checks, but run in localtests

rasterbase <- paste0(gridbase,"/seasonal/air_temperature_mean")
ftp.files <- indexFTP("/16_DJF", base=rasterbase, dir=tempdir())
localfiles <- dataDWD(ftp.files[1:2], base=rasterbase, joinbf=TRUE,
                      dir=locdir(), read=FALSE)
rf <- readDWD(localfiles[1])
rf <- readDWD(localfiles[1]) # runs faster at second time due to skip=TRUE
terra::plot(rf)

plotRadar(rf, proj="seasonal", extent=NULL)

testthat::expect_equal(c(terra::minmax(rf)), c(-8.2,4.4))
rf10 <- readDWD(localfiles[1], dividebyten=FALSE)
terra::plot(rf10)
testthat::expect_equal(c(terra::minmax(rf10*1)), c(-82,44))
}
}
\seealso{
\code{\link[=readDWD]{readDWD()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Dec 2018
}
