% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsaalen.R
\name{rsaalen}
\alias{rsaalen}
\title{Fit an extended additive hazards model using relative survival}
\usage{
rsaalen(
  formula,
  data,
  variance = FALSE,
  var_estimator = "dN",
  ratetable = relsurv::slopop,
  rmap,
  split.transitions,
  add.times
)
}
\arguments{
\item{formula}{a formula object, with the response as a \code{Surv} object
on the left of a \code{~} operator, and, if desired, terms separated by the
\code{+} operator on the right.}

\item{data}{a data.frame in which to interpret the variables named in the
\code{formula}.}

\item{variance}{a logical value indicating whether the variances of the hazards should be computed.
Default is FALSE.}

\item{var_estimator}{Choose variance estimator, in the same way as in survaalen. The default option 'dN' uses dN(t)-dLambda_P(t) in the variance estimator, equivalent to formula 4.63 in Aalen et al. (2008). Option 'XdB' uses X*dB(t), see formula 4.64 in Aalen et al. (2008).}

\item{ratetable}{a table of event rates, organized as a \code{ratetable} object, such as \code{slopop}.}

\item{rmap}{an optional list to be used if the variables are not organized and named in the same way as in the \code{ratetable} object.}

\item{split.transitions}{only relevant if a multi-state model is fitted. An integer vector containing the numbered transitions that should be split. Use same numbering as in the given transition matrix.}

\item{add.times}{specific times at which estimates should be obtained.}
}
\value{
An object of class \code{aalen.model}.
}
\description{
Fits the Aalen additive hazard model using relative survival. The function can be used for multi-state model
data (as in the package mstate; class msdata) by supplying the start and stop times in the
Surv object and adding a strata(trans) object in the formula (where trans denotes the
transition in the multi-state model).
}
\examples{

# Survival:
data(rdata)
mod <- rsaalen(Surv(time, cens)~sex+age, data=rdata, ratetable=slopop,
     rmap=list(age=age*365.241))
head(mod$coefficients)
tail(mod$coefficients)

# Multi-state model:
data(ebmt1wide)
# Generate sex and year data (for illustrative purposes since it is not given in the data):
ebmt1wide$sex <- sample(1:2, size = nrow(ebmt1wide), replace = TRUE)
ebmt1wide$year <- as.Date('2010-01-01')

mod <- rsaalen(Surv(Tstart, Tstop, status)~age.1+age.2+age.3+strata(trans), data=ebmt1wide,
                 ratetable = slopop, rmap = list(age=age*365.241), split.transitions = 2:3)
head(mod$coefficients$trans1)
head(mod$coefficients$trans2)
head(mod$coefficients$trans3)
}
\seealso{
\code{\link{survaalen}}
}
\author{
Damjan Manevski
}
\keyword{survival}
