% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_ops.R
\name{at}
\alias{at}
\alias{at.array}
\alias{at.tensor}
\title{Evaluate a symbolic array}
\usage{
at(x, vars)

\method{at}{array}(x, vars)

\method{at}{tensor}(x, vars)
}
\arguments{
\item{x}{A symbolic \code{\link[=array]{array()}} or a \code{\link[=tensor]{tensor()}}.}

\item{vars}{A named vector with parameter-value assignments.
Each named entry represents a substitution of a symbol with the given value.}
}
\value{
A numeric \code{\link[=array]{array()}} or \code{\link[=tensor]{tensor()}}.
}
\description{
Evaluates a symbolic array at a particular point in parameter space.
Partial evaluation is not allowed, all variables/symbols need to be accounted
for. The result is a numeric array.
}
\examples{
g_sph(3) |> at(c(ph1 = 0, ph2 = 0))
}
\concept{eval}
