% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq_num.R
\name{comp_freq}
\alias{comp_freq}
\title{Compute frequencies from (3 essential) probabilities.}
\usage{
comp_freq(
  prev = num$prev,
  sens = num$sens,
  spec = num$spec,
  N = num$N,
  round = TRUE,
  sample = FALSE
)
}
\arguments{
\item{prev}{The condition's prevalence \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).}

\item{N}{The number of individuals in the population.
If \code{\link{N}} is unknown (\code{NA}),
a suitable minimum value is computed by \code{\link{comp_min_N}}.}

\item{round}{Boolean value that determines whether frequency values
are rounded to the nearest integer.
Default: \code{round = TRUE}.

Note: Removed \code{n_digits} parameter:  Number of digits to which frequency values
are to be rounded when \code{round = FALSE}.
Default: \code{n_digits = 5}.}

\item{sample}{Boolean value that determines whether frequency values
are sampled from \code{N}, given the probability values of
\code{prev}, \code{sens}, and \code{spec}.
Default: \code{sample = FALSE}.

Note: Sampling uses \code{sample()} and returns integer values.}
}
\value{
A list \code{\link{freq}} containing 11 key frequency values.
}
\description{
\code{comp_freq} computes frequencies (typically
as rounded integers) given 3 basic probabilities --
\code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}} --
for a population of \code{\link{N}} individuals.
It returns a list of 11 key frequencies \code{\link{freq}}
as its output.
}
\details{
In addition to \code{\link{prev}}, both
\code{\link{sens}} and \code{\link{spec}} are necessary arguments.
If only their complements \code{\link{mirt}} or \code{\link{fart}}
are known, use the wrapper function \code{\link{comp_freq_prob}}
which also accepts \code{\link{mirt}} and \code{\link{fart}} as inputs
(but requires that the entire set of provided probabilities is
sufficient and consistent).
Alternatively, use \code{\link{comp_complement}},
\code{\link{comp_comp_pair}}, or \code{\link{comp_complete_prob_set}}
to obtain the 3 essential probabilities.

\code{comp_freq} is the frequency counterpart to the
probability function \code{\link{comp_prob}}.

By default, \code{comp_freq} and its wrapper function
\code{\link{comp_freq_prob}}
round frequencies to nearest integers to avoid decimal values in
\code{\link{freq}} (i.e., \code{round = TRUE} by default).
When frequencies are rounded, probabilities computed from
\code{\link{freq}} may differ from exact probabilities.
Using the option \code{round = FALSE} turns off rounding.

Key relationships between probabilities and frequencies:

\itemize{

\item Three perspectives on a population:

A population of \code{\link{N}} individuals can be split into 2 subsets of frequencies
in 3 different ways:

   \enumerate{

   \item by condition:

   \code{\link{N} = \link{cond_true} + \link{cond_false}}

   The frequency \code{\link{cond_true}} depends on the prevalence \code{\link{prev}}
   and
   the frequency \code{\link{cond_false}} depends on the prevalence's complement \code{1 - \link{prev}}.

   \item by decision:

   \code{\link{N} = \link{dec_pos} + \link{dec_neg}}

   The frequency \code{\link{dec_pos}} depends on the proportion of positive decisions \code{\link{ppod}}
   and
   the frequency \code{\link{dec_neg}} depends on the proportion of negative decisions \code{1 - \link{ppod}}.

   \item by accuracy (i.e., correspondence of decision to condition):

   \code{\link{N} = \link{dec_cor} + \link{dec_err}}

   }

Each perspective combines 2 pairs of the 4 essential probabilities (hi, mi, fa, cr).

When providing probabilities, the population size \code{\link{N}} is a free parameter (independent of the
essential probabilities \code{\link{prev}}, \code{\link{sens}}, and \code{\link{spec}}).

If \code{\link{N}} is unknown (\code{NA}), a suitable minimum value can be computed by \code{\link{comp_min_N}}.

\item Defining probabilities in terms of frequencies:

Probabilities \emph{are} -- determine, describe, or are defined as -- the relationships between frequencies.
Thus, they can be computed as ratios between frequencies:

  \enumerate{

  \item prevalence \code{\link{prev}}:

  \code{\link{prev} = \link{cond_true}/\link{N}  =  (\link{hi} + \link{mi}) / (\link{hi} + \link{mi} + \link{fa} + \link{cr})}

  \item sensitivity \code{\link{sens}}:

  \code{\link{sens} = \link{hi}/\link{cond_true}  =  \link{hi} / (\link{hi} + \link{mi})  =  (1 - \link{mirt})}

  \item miss rate \code{\link{mirt}}:

  \code{\link{mirt} = \link{mi}/\link{cond_true}  =  \link{mi} / (\link{hi} + \link{mi})  =  (1 - \link{sens})}

  \item specificity \code{\link{spec}}:

  \code{\link{spec} = \link{cr}/\link{cond_false}  =  \link{cr} / (\link{fa} + \link{cr})  =  (1 - \link{fart})}

  \item false alarm rate \code{\link{fart}}:

  \code{\link{fart} = \link{fa}/\link{cond_false}  =  \link{fa} / (\link{fa} + \link{cr})  =  (1 - \link{spec})}

  \item proportion of positive decisions \code{\link{ppod}}:

  \code{\link{ppod} = \link{dec_pos}/\link{N}  =  (\link{hi} + \link{fa}) / (\link{hi} + \link{mi} + \link{fa} + \link{cr})}

  \item positive predictive value \code{\link{PPV}}:

  \code{\link{PPV} = \link{hi}/\link{dec_pos}  =  \link{hi} / (\link{hi} + \link{fa})  =  (1 - \link{FDR})}

  \item negative predictive value \code{\link{NPV}}:

  \code{\link{NPV} = \link{cr}/\link{dec_neg}  =  \link{cr} / (\link{mi} + \link{cr})  =  (1 - \link{FOR})}

  \item false detection rate \code{\link{FDR}}:

  \code{\link{FDR} = \link{fa}/\link{dec_pos}  =  \link{fa} / (\link{hi} + \link{fa})  =  (1 - \link{PPV})}

  \item false omission rate \code{\link{FOR}}:

  \code{\link{FOR} = \link{mi}/\link{dec_neg}  =  \link{mi} / (\link{mi} + \link{cr})  =  (1 - \link{NPV})}

  \item accuracy \code{\link{acc}}:

  \code{\link{acc} = \link{dec_cor}/\link{N}  =  (\link{hi} + \link{cr}) / (\link{hi} + \link{mi} + \link{fa} + \link{cr})}

  \item rate of hits, given accuracy \code{p_acc_hi}:

  \code{p_acc_hi = \link{hi}/\link{dec_cor} = (1 - \link{cr}/\link{dec_cor})}

  \item rate of false alarms, given inaccuracy \code{p_err_fa}:

  \code{p_err_fa = \link{fa}/\link{dec_err} = (1 - \link{mi}/\link{dec_err})}

   }

   Beware of rounding and sampling issues!
   If frequencies are rounded (by \code{round = TRUE} in \code{\link{comp_freq}})
   or sampled from probabilities (by \code{sample = TRUE}),
   then any probabilities computed from \code{\link{freq}} may differ
   from original and exact probabilities.

}

Functions translating between representational formats:
\code{\link{comp_prob_prob}}, \code{\link{comp_prob_freq}},
\code{\link{comp_freq_prob}}, \code{\link{comp_freq_freq}}
(see documentation of \code{\link{comp_prob_prob}} for details).
}
\examples{
comp_freq()          # ok, using current defaults
length(comp_freq())  # 11 key frequencies

# Rounding:
comp_freq(prev = .5, sens = .5, spec = .5, N = 1)   # yields fa = 1 (see ?round for reason)
comp_freq(prev = .1, sens = .9, spec = .8, N = 10)  # 1 hit (TP, rounded)
comp_freq(prev = .1, sens = .9, spec = .8, N = 10, round = FALSE)    # hi = .9
comp_freq(prev = 1/3, sens = 6/7, spec = 2/3, N = 1, round = FALSE)  # hi = 0.2857143

# Sampling (from probabilistic description):
comp_freq_prob(prev = .5, sens = .5, spec = .5, N = 100, sample = TRUE)  # freq values vary

# Extreme cases:
comp_freq(prev = 1, sens = 1, spec = 1, 100)  # ok, N hits (TP)
comp_freq(prev = 1, sens = 1, spec = 0, 100)  # ok, N hits
comp_freq(prev = 1, sens = 0, spec = 1, 100)  # ok, N misses (FN)
comp_freq(prev = 1, sens = 0, spec = 0, 100)  # ok, N misses
comp_freq(prev = 0, sens = 1, spec = 1, 100)  # ok, N correct rejections (TN)
comp_freq(prev = 0, sens = 1, spec = 0, 100)  # ok, N false alarms (FP)

# Watch out for:
comp_freq(prev = 1, sens = 1, spec = 1, N = NA)  # ok, but warning that N = 1 was computed
comp_freq(prev = 1, sens = 1, spec = 1, N =  0)  # ok, but all 0 + warning (extreme case: N hits)
comp_freq(prev = .5, sens = .5, spec = .5, N = 10, round = TRUE)   # ok, rounded (see mi and fa)
comp_freq(prev = .5, sens = .5, spec = .5, N = 10, round = FALSE)  # ok, not rounded

# Ways to fail:
comp_freq(prev = NA,  sens = 1, spec = 1,  100)   # NAs + warning (prev NA)
comp_freq(prev = 1,  sens = NA, spec = 1,  100)   # NAs + warning (sens NA)
comp_freq(prev = 1,  sens = 1,  spec = NA, 100)   # NAs + warning (spec NA)
comp_freq(prev = 8,  sens = 1,  spec = 1,  100)   # NAs + warning (prev beyond range)
comp_freq(prev = 1,  sens = 8,  spec = 1,  100)   # NAs + warning (sens beyond range)

}
\seealso{
\code{\link{comp_freq_prob}} corresponding wrapper function;
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{freq}} contains current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{comp_comp_pair}} computes pairs of complements;
\code{\link{comp_complete_prob_set}} completes valid sets of probabilities;
\code{\link{comp_min_N}} computes a suitable population size \code{\link{N}} (if missing).

Other functions computing frequencies: 
\code{\link{comp_freq_freq}()},
\code{\link{comp_freq_prob}()},
\code{\link{comp_min_N}()},
\code{\link{comp_prob_prob}()}
}
\concept{functions computing frequencies}
