% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_xxxx_prob.R
\name{comp_prob_prob}
\alias{comp_prob_prob}
\title{Compute probabilities from (3 essential) probabilities.}
\usage{
comp_prob_prob(
  prev = prob$prev,
  sens = prob$sens,
  mirt = NA,
  spec = prob$spec,
  fart = NA,
  tol = 0.01
)
}
\arguments{
\item{prev}{The condition's prevalence value \code{\link{prev}}
(i.e., the probability of condition being \code{TRUE}).}

\item{sens}{The decision's sensitivity value \code{\link{sens}}
(i.e., the conditional probability of a positive decision
provided that the condition is \code{TRUE}).
\code{sens} is optional when its complement \code{\link{mirt}} is provided.}

\item{mirt}{The decision's miss rate value \code{\link{mirt}}
(i.e., the conditional probability of a negative decision
provided that the condition is \code{TRUE}).
\code{mirt} is optional when its complement \code{\link{sens}} is provided.}

\item{spec}{The decision's specificity value \code{\link{spec}}
(i.e., the conditional probability
of a negative decision provided that the condition is \code{FALSE}).
\code{spec} is optional when its complement \code{\link{fart}} is provided.}

\item{fart}{The decision's false alarm rate \code{\link{fart}}
(i.e., the conditional probability
of a positive decision provided that the condition is \code{FALSE}).
\code{fart} is optional when its complement \code{\link{spec}} is provided.}

\item{tol}{A numeric tolerance value for \code{\link{is_complement}}.
Default: \code{tol = .01}.}
}
\value{
A list \code{\link{prob}} containing 13 key probability values.
}
\description{
\code{comp_prob_prob} computes current probability information
from a sufficient and valid set of 3 essential probabilities
(\code{\link{prev}}, and
\code{\link{sens}} or its complement \code{\link{mirt}}, and
\code{\link{spec}} or its complement \code{\link{fart}}).
It returns a list of 13 key probabilities (\code{\link{prob}})
as its output.
}
\details{
\code{comp_prob_prob} is a wrapper function for the more basic
function \code{\link{comp_prob}}.

Extreme probabilities (sets containing 2 or more
probabilities of 0 or 1) may yield unexpected values
(e.g., predictive values \code{\link{PPV}} or \code{\link{NPV}}
turning \code{NaN} when \code{\link{is_extreme_prob_set}}
evaluates to \code{TRUE}).

Key relationships between frequencies and probabilities
(see documentation of \code{\link{comp_freq}} or \code{\link{comp_prob}} for details):

\itemize{

  \item Three perspectives on a population:

  by condition / by decision / by accuracy.

  \item Defining probabilities in terms of frequencies:

  Probabilities can be computed as ratios between frequencies, but beware of rounding issues.

}

Functions translating between representational formats:

\enumerate{

   \item \code{comp_prob_prob} (defined here) is
   a wrapper function for \code{\link{comp_prob}} and
   an analog to 3 other format conversion functions:

   \item \code{\link{comp_prob_freq}} computes
   current \emph{probability} information contained in \code{\link{prob}}
   from 4 essential frequencies
   (\code{\link{hi}}, \code{\link{mi}}, \code{\link{fa}}, \code{\link{cr}}).

   \item \code{\link{comp_freq_prob}} computes
   current \emph{frequency} information contained in \code{\link{freq}}
   from 3 essential probabilities
   (\code{\link{prev}}, \code{\link{sens}}, \code{\link{spec}}).

   \item \code{\link{comp_freq_freq}} computes
   current \emph{frequency} information contained in \code{\link{freq}}
   from 4 essential frequencies
   (\code{\link{hi}}, \code{\link{mi}}, \code{\link{fa}}, \code{\link{cr}}).

 }
}
\examples{
# Basics:
comp_prob_prob(prev = .11, sens = .88, spec = .77)                        # ok: PPV = 0.3210614
comp_prob_prob(prev = .11, sens = NA, mirt = .12, spec = NA, fart = .23)  # ok: PPV = 0.3210614
comp_prob_prob()          # ok, using current defaults
length(comp_prob_prob())  # 13 key probability values

# Ways to work:
comp_prob_prob(.99, sens = .99, spec = .99)              # ok: PPV = 0.999898
comp_prob_prob(.99, sens = .90, spec = NA, fart = .10)   # ok: PPV = 0.9988789

# Watch out for extreme cases:
comp_prob_prob(1, sens = 0, spec = 1)      # ok, but with warnings (as PPV & FDR are NaN)
comp_prob_prob(1, sens = 0, spec = 0)      # ok, but with warnings (as PPV & FDR are NaN)
comp_prob_prob(1, sens = 0, spec = NA, fart = 0)  # ok, but with warnings (as PPV & FDR are NaN)
comp_prob_prob(1, sens = 0, spec = NA, fart = 1)  # ok, but with warnings (as PPV & FDR are NaN)

comp_prob_prob(1, sens = 1, spec = 0)      # ok, but with warnings (as NPV & FOR are NaN)
comp_prob_prob(1, sens = 1, spec = 1)      # ok, but with warnings (as NPV & FOR are NaN)
comp_prob_prob(1, sens = 1, spec = NA, fart = 0)  # ok, but with warnings (as NPV & FOR are NaN)
comp_prob_prob(1, sens = 1, spec = NA, fart = 1)  # ok, but with warnings (as NPV & FOR are NaN)

# Ways to fail:
comp_prob_prob(NA, 1, 1, NA)  # only warning: invalid set (prev not numeric)
comp_prob_prob(8,  1, 1, NA)  # only warning: prev no probability
comp_prob_prob(1,  8, 1, NA)  # only warning: sens no probability
comp_prob_prob(1,  1, 1,  1)  # only warning: is_complement not in tolerated range

}
\seealso{
\code{\link{comp_freq_prob}} computes current frequency information from (3 essential) probabilities;
\code{\link{comp_freq_freq}} computes current frequency information from (4 essential) frequencies;
\code{\link{comp_prob_freq}} computes current probability information from (4 essential) frequencies;
\code{\link{num}} contains basic numeric variables;
\code{\link{init_num}} initializes basic numeric variables;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information;
\code{\link{comp_complement}} computes a probability's complement;
\code{\link{comp_comp_pair}} computes pairs of complements;
\code{\link{comp_complete_prob_set}} completes valid sets of probabilities;
\code{\link{comp_min_N}} computes a suitable population size \code{\link{N}} (if missing).

Other functions computing frequencies: 
\code{\link{comp_freq}()},
\code{\link{comp_freq_freq}()},
\code{\link{comp_freq_prob}()},
\code{\link{comp_min_N}()}

Other format conversion functions: 
\code{\link{comp_freq_freq}()},
\code{\link{comp_freq_prob}()},
\code{\link{comp_prob_freq}()}
}
\concept{format conversion functions}
\concept{functions computing frequencies}
