% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{extract}
\alias{extract}
\title{Extract Posterior Samples from an `rjuliabugs` S3 Object}
\usage{
extract(rjuliabugs, pars = NULL, type = "array", include = TRUE)
}
\arguments{
\item{rjuliabugs}{An S3 object of class `rjuliabugs`, typically returned by a call to the `juliaBUGS()` function.
Must contain a `params` 3D array and `mcmc` list with fields `params_to_save` and `n_chain`.}

\item{pars}{Character vector of parameter names to extract. If `NULL`, defaults to `rjuliabugs$mcmc$params_to_save`.}

\item{type}{Character string indicating output type: one of `"array"` (default), `"rvar"`, `"mcmc"`, or `"draws"`.}

\item{include}{Logical; if `TRUE`, extract only `pars`; if `FALSE`, exclude `pars`.}
}
\value{
The posterior samples in the specified format:
\itemize{
  \item a 3D `array` [iterations × chains × parameters],
  \item a `posterior::rvar` object,
  \item a `coda::mcmc` or `coda::mcmc.list`,
  \item or a `posterior::draws_array`/`draws_list`.
}
}
\description{
Extracts posterior samples for specified parameters from a fitted `rjuliabugs` object. Output can be returned
in several formats depending on downstream analysis requirements.
}
