% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetObject.R
\name{subsetLigerDataset}
\alias{subsetLigerDataset}
\alias{subsetH5LigerDataset}
\alias{subsetMemLigerDataset}
\title{Subset ligerDataset object}
\usage{
subsetLigerDataset(
  object,
  featureIdx = NULL,
  cellIdx = NULL,
  useSlot = NULL,
  newH5 = TRUE,
  filename = NULL,
  filenameSuffix = NULL,
  chunkSize = 1000,
  verbose = getOption("ligerVerbose", TRUE),
  returnObject = TRUE,
  ...
)

subsetH5LigerDataset(
  object,
  featureIdx = NULL,
  cellIdx = NULL,
  useSlot = NULL,
  newH5 = TRUE,
  filename = NULL,
  filenameSuffix = NULL,
  chunkSize = 1000,
  verbose = getOption("ligerVerbose", TRUE),
  returnObject = TRUE
)

subsetMemLigerDataset(
  object,
  featureIdx = NULL,
  cellIdx = NULL,
  useSlot = NULL,
  returnObject = TRUE
)
}
\arguments{
\item{object}{\linkS4class{ligerDataset} object. HDF5 based object if using
\code{subsetH5LigerDataset}, in-memory data for \code{subsetMemLigerDataset}.}

\item{featureIdx}{Character, logical or numeric index that can subscribe
features. Missing or \code{NULL} for all features.}

\item{cellIdx}{Character, logical or numeric index that can subscribe cells.
Missing or \code{NULL} for all cells.}

\item{useSlot}{The slot(s) to only consider. Choose one or more from
\code{"rawData"}, \code{"normData"} and \code{"scaleData"}. Default
\code{NULL} subsets the whole object including analysis result matrices.}

\item{newH5}{Whether to create a new H5 file on disk for the subset dataset
if \code{object} is HDF5 based. \code{TRUE} writes a new one, \code{FALSE}
returns in memory data.}

\item{filename}{Filename of the new H5 file if being created. Default
\code{NULL} adds suffix \code{".subset_{yymmdd_HHMMSS}.h5"} to the original
name.}

\item{filenameSuffix}{Instead of specifying the exact filename, set a suffix
for the new files so the new filename looks like
\code{original.h5.[suffix].h5}. Default \code{NULL}.}

\item{chunkSize}{Integer. Number of maximum number of cells in each chunk,
Default \code{1000}.}

\item{verbose}{Logical. Whether to show information of the progress. Default
\code{getOption("ligerVerbose")} or \code{TRUE} if users have not set.}

\item{returnObject}{Logical, whether to return a \linkS4class{ligerDataset}
object for result. Default \code{TRUE}. \code{FALSE} returns a list
containing requested values.}

\item{...}{Arguments passed to \code{subsetH5LigerDataset}}
}
\value{
Subset \code{object}
}
\description{
This function subsets a \linkS4class{ligerDataset} object with
valid feature and cell indices. For HDF5 based object, options are available
for subsetting data into memory or a new on-disk H5 file. Feature and cell
subscription is always based on the size of rawData. Therefore, the feature
subsetting on scaled data, which usually contains already a subset of
features, will select the intersection between the wanted features and the
set available from scaled data.
}
\examples{
ctrl <- dataset(pbmc, "ctrl")
ctrl.small <- subsetLigerDataset(ctrl, cellIdx = 1:5)
ctrl.tiny <- ctrl[1:5, 1:5]
}
