% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{simSVD}
\alias{simSVD}
\title{Simulate SVD and measure performances of various algorithms}
\usage{
simSVD(
  trueSVD,
  svdfun,
  B = 100,
  seed = NULL,
  dist = "normal",
  tau = 0.95,
  outlier = FALSE,
  out_method = "element",
  out_value = 10,
  out_prop = 0.1,
  return_details = FALSE,
  ...
)
}
\arguments{
\item{trueSVD}{\code{list}, containing three different named components.
\itemize{
\item d - a \code{vector} containing the singular values.
\item u - a \code{matrix} with left singular vectors, each column being a singular vector.
\item v - a \code{matrix} with right singular vectors, each column being a singular vector.
}}

\item{svdfun}{\code{function} which takes a \code{numeric} matrix as first argument and
returns singular value decomposition of it as a \code{list}, with three components
 d, u and v as indicated before.}

\item{B}{\code{numeric}, denoting the number of Monte Carlo simulation.}

\item{seed}{\code{numeric}, a seed value used for reproducibility.}

\item{dist}{\code{character} string, denoting the distribution from which errors will be generated. 
It must be equal to one of the following: \code{\link[stats:rnorm]{normal}}, \code{\link[stats:rcauchy]{cauchy}}, 
\code{\link[stats:rexp]{exp}}, \code{\link[stats:rlogis]{logis}}, \code{\link[stats:rlnorm]{lognormal}}}

\item{tau}{\code{numeric}, a value between 0 and 1, see details for more.}

\item{outlier}{\code{logical}, if \code{TRUE}, simulates the situation by adding outliers.}

\item{out_method}{\code{character}, the method to add outliers. Must be one of "element", "row" or "col". See \link{AddOutlier} for details.}

\item{out_value}{\code{numeric}, the outlying observation. See \link{AddOutlier} for details.}

\item{out_prop}{a \code{numeric}, between 0 and 1 denoting the proportion of contamination. See \link{AddOutlier} for details.}

\item{return_details}{\code{logical}, whether to return detailed results for each Monte Carlo simulation. See value for details.}

\item{...}{extra arguments to be passed to \code{svdfun} function.}
}
\value{
Based on whether \code{return_details} is \code{TRUE} or \code{FALSE}, returns a list with two or one components.
\itemize{
\item Simulations :
\itemize{
\item Lambda - A \code{matrix} containing obtained singular values from all Monte Carlo Simulations.
\item Left - A \code{matrix} containing the dissimilarities between left singular vectors of true SVD and obtained SVD.
\item Right - A \code{matrix} containing the dissimilarities between right singular vectors of true SVD and obtained SVD.
}
\item Summary :
\itemize{
\item Bias - A \code{numeric vector} showing biases of the singular vectors obtained by \code{svdfun} algorithm.
\item MSE - A \code{numeric vector} showing MSE of the singular vectors obtained by \code{svdfun} algorithm.
\item Variance - A \code{numeric vector} showing variances of the singular vectors obtained by \code{svdfun} algorithm.
\item Left - A \code{numeric vector} showing average dissimilarities between true and estimated left singular vectors.
\item Right - A \code{numeric vector} showing average dissimilarities between true and estimated right singular vectors.
}
}
If \code{return_details} is \code{FALSE}, only Summary component of the larger list is returned.
}
\description{
\code{simSVD} simulates various models for the errors in the data matrix, and summarize
performance of a singular value decomposition algorithm under presence or absence of 
outlying data introduced through various outlying schemes, using Monte Carlo approach.
}
