% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.R
\name{read_table}
\alias{read_table}
\title{Read a TiddlyWiki Table into a Data Frame}
\usage{
read_table(table, header = TRUE)
}
\arguments{
\item{table}{A character string representing the TiddlyWiki table.}

\item{header}{A logical value indicating whether the first row should be treated as column headers. Default is TRUE.}
}
\value{
A data frame containing the parsed table data.
}
\description{
This function parses a table written in TiddlyWiki format and converts it into an R data frame.
It can optionally treat the first row as a header.
}
\examples{
table <- "|!Cell1 |!Cell2 |\n|Cell3 |Cell4 |"
df <- read_table(table, header = TRUE)
print(df)

}
