% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rel.R
\name{SAR_fitness}
\alias{SAR_fitness}
\alias{makeRel_SAR}
\title{Update natural mortality of juveniles}
\usage{
SAR_fitness(
  x = -1,
  y = 1,
  envir = c("natural", "hatchery"),
  rel_loss = 1,
  s = 1,
  nyears,
  Mbase
)

makeRel_SAR(
  p_smolt = 1,
  s = 1,
  envir = c("natural", "hatchery"),
  rel_loss,
  nyears,
  Mbase
)
}
\arguments{
\item{x}{Integer, simulation number from openMSE}

\item{y}{Integer, simulation year (including historical years)}

\item{envir}{Character, whether to obtain the fitness value for the natural or hatchery environment.}

\item{rel_loss}{Numeric, the loss exponent for the juveniles}

\item{s}{Integer, the salmonMSE population index. Used to search for the fitness value}

\item{nyears}{Integer, the number of historical years in the operating model}

\item{Mbase}{Array \verb{[nsim, n_age, proyears]} the base natural mortality value in the openMSE operating model.}

\item{p_smolt}{Integer, the population index for the juvenile population in the openMSE model}
}
\value{
\itemize{
\item \code{smolt_func()} returns a numeric for the ratio of the realized smolt production vs. the hypothetical value if there were no
hatchery, en route mortality, or habitat improvement
\item \code{makeRel_smolt} returns a list that is passed to openMSE as a inter-population relationship
}
}
\description{
Internal function that updates juvenile natural mortality in the marine environement due
to fitness
\itemize{
\item \code{SAR_fitness()} calculates the new natural mortality value
\item \code{makeRel_SAR} generates a list for openMSE to use in the simulations
}
}
\keyword{internal}
