% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fig_height_h_barchart.R
\name{fig_height_h_barchart2}
\alias{fig_height_h_barchart2}
\title{Estimate figure height for a horizontal bar chart}
\usage{
fig_height_h_barchart2(
  ggobj,
  main_font_size = 7,
  strip_angle = 0,
  freq = FALSE,
  x_axis_label_width = 20,
  strip_width = 20,
  legend_location = c("plot", "panel"),
  n_legend_lines = NULL,
  showNA = c("ifany", "never", "always"),
  legend_key_chars_equivalence = 5,
  multiplier_per_horizontal_line = NULL,
  multiplier_per_vertical_letter = 1,
  multiplier_per_facet = 1,
  multiplier_per_legend_line = 1,
  fixed_constant = 0,
  figure_width_in_cm = 14,
  margin_in_cm = 0,
  max = 8,
  min = 1
)
}
\arguments{
\item{ggobj}{\code{ggplot2}-object}

\item{main_font_size}{Numeric. Font size for the main text.}

\item{strip_angle}{Integer. Angle of the strip text.}

\item{freq}{Logical. If TRUE, frequency plot with categories next to each other. If FALSE (default), proportion plot with stacked categories.}

\item{x_axis_label_width, strip_width}{Numeric. Width allocated for x-axis labels and strip labels respectively.}

\item{legend_location}{Character. Location of the legend. "plot" (default) or "panel".}

\item{n_legend_lines}{Integer. Number of lines in the legend.}

\item{showNA}{String, one of "ifany", "always" or "never". Not yet in use.}

\item{legend_key_chars_equivalence}{Integer. Approximate number of characters the legend key equals.}

\item{multiplier_per_horizontal_line}{Numeric. Multiplier per horizontal line.}

\item{multiplier_per_vertical_letter}{Numeric. Multiplier per vertical letter.}

\item{multiplier_per_facet}{Numeric. Multiplier per facet height.}

\item{multiplier_per_legend_line}{Numeric. Multiplier per legend line.}

\item{fixed_constant}{Numeric. Fixed constant to be added to the height.}

\item{figure_width_in_cm}{Numeric. Width of the figure in centimeters.}

\item{margin_in_cm}{Numeric. Margin in centimeters.}

\item{max}{Numeric. Maximum height.}

\item{min}{Numeric. Minimum height.}
}
\value{
Numeric value representing the estimated height of the figure.
}
\description{
Taking an object from \code{makeme()}, this function estimates the height of a
figure for a horizontal bar chart.
}
\examples{
fig_height_h_barchart2(makeme(data = ex_survey, dep = b_1:b_2, indep = x1_sex))
}
