% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_plot_dbar.R
\name{scf_plot_dbar}
\alias{scf_plot_dbar}
\title{Plot Bar Chart of a Discrete Variable from SCF Data}
\usage{
scf_plot_dbar(
  design,
  variable,
  title = NULL,
  xlab = NULL,
  ylab = "Percent",
  angle = 30,
  fill = "#0072B2",
  label_map = NULL
)
}
\arguments{
\item{design}{A \code{scf_mi_survey} object created by \code{\link[=scf_load]{scf_load()}}. Must contain valid implicates.}

\item{variable}{A one-sided formula specifying a categorical variable (e.g., \code{~racecl}).}

\item{title}{Optional character string for the plot title. Default: \code{"Distribution of <variable>"}.}

\item{xlab}{Optional x-axis label. Default: variable name.}

\item{ylab}{Optional y-axis label. Default: \code{"Percent"}.}

\item{angle}{Integer. Rotation angle for x-axis labels. Default is \code{30}.}

\item{fill}{Fill color for bars. Default is \code{"#0072B2"}.}

\item{label_map}{Optional named vector to relabel x-axis category labels.}
}
\value{
A \code{ggplot2} object representing the pooled bar chart.
}
\description{
Creates a bar chart that visualizes the distribution of a discrete variable.
}
\section{Implementation}{

This function internally calls \code{\link[=scf_freq]{scf_freq()}} to compute population proportion
estimates, which are then plotted using \code{ggplot2::geom_col()}. The default
output is scaled to percent and can be customized via title, axis labels,
angle, and color.
}

\section{Details}{

Produces a bar chart of category proportions from a one-way tabulation,
pooled across SCF implicates using \code{\link[=scf_freq]{scf_freq()}}. This function summarizes
weighted sample composition and communicates categorical distributions
effectively in descriptive analysis.
}

\section{Dependencies}{

Requires the \code{ggplot2} package.
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td <- tempfile("plot_dbar_")
dir.create(td)

src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Bar chart of education categories
scf_plot_dbar(scf2022, ~edcl)

# Do not implement these lines in real analysis: Cleanup for package check
unlink(td, recursive = TRUE, force = TRUE)

}
\seealso{
\code{\link[=scf_freq]{scf_freq()}}, \code{\link[=scf_plot_bbar]{scf_plot_bbar()}}, \code{\link[=scf_xtab]{scf_xtab()}}
}
