% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rppi.R, R/rppi_examplemodels.R
\name{rppi}
\alias{rppi}
\alias{rppi_egmodel}
\title{Simulate from a PPI Model}
\usage{
rppi(n, ..., paramvec = NULL, maxden = 4, maxmemorysize = 1e+05)

rppi_egmodel(n, maxden = 4)
}
\arguments{
\item{n}{Number of samples to generate}

\item{...}{
  Arguments passed on to \code{\link[=ppi_paramvec]{ppi_paramvec}}
  \describe{
    \item{\code{AL}}{Either \code{NULL}, a p-1 x p-1 symmetric matrix, a number, or "diag".
If NULL then all \eqn{A_L} elements will be set to NA.
If a single number, then \eqn{A_L} will be fixed as a matrix of the given value.
If "diag" then the non-diagonal elements of \eqn{A_L} will be fixed to 0, and the diagonal will be \code{NA}.}
    \item{\code{bL}}{Either \code{NULL}, a number, or a vector of length p-1.
If \code{NULL}, then all elements of \eqn{b_L} will be set to \code{NA}.
If a single number, then \eqn{b_L} will be fixed at the supplied value.}
    \item{\code{beta}}{Either \code{NULL}, a number, or a vector of length p.
If NULL then all elements of \eqn{\beta} will be set to \code{NA}.
If a single number then the \eqn{\beta} elements will be fixed at the given number.}
    \item{\code{betaL}}{Either \code{NULL}, a number, or a vector of length p-1.
If \code{NULL} then the 1...(p-1)th \eqn{\beta} elements will be set to \code{NA}.
If a single number then the 1...(p-1)th \eqn{\beta} elements will be fixed at the given number.}
    \item{\code{betap}}{Either \code{NULL} or a number.
If \code{NULL} then the \code{p}th element of \eqn{\beta} will be set to \code{NA}, and \code{\link[=ppi]{ppi()}} will estimate it.
If a number, then the pth element of \eqn{\beta} will be fixed at the given value.}
    \item{\code{p}}{The number of components. If \code{NULL} then \code{p} will be inferred from other inputs.}
    \item{\code{Astar}}{The \eqn{A^*} matrix (a p by p symmetric matrix)}
  }}

\item{paramvec}{The PPI parameter vector, created easily using \code{\link[=ppi_paramvec]{ppi_paramvec()}} and also returned by \code{\link[=ppi]{ppi()}}. Use \code{paramvec} instead of \code{...}.}

\item{maxden}{This is the constant \eqn{log(C)} in \insertCite{@Appendix A.1.3 @scealy2023sc}{scorematchingad}.}

\item{maxmemorysize}{Advanced use. The maximum size, in bytes, for matrices containing simulated Dirichlet samples. The default of \code{1E5} corresponds to 100 mega bytes.}
}
\value{
A matrix with \code{n} rows and \code{p} columns. Each row is an independent draw from the specified PPI distribution.

\code{rppi_egmodel} returns a list:
\itemize{
\item \code{sample} A matrix of the simulated samples (\code{n} rows)
\item \code{p} The number of components of the model
\item \code{theta} The PPI parameter vector
\item \code{AL} The \eqn{A_L} parameter matrix
\item \code{bL} The \eqn{b_L} parameter vector
\item \code{beta} The \eqn{\beta} parameter vector
}
}
\description{
Given parameters of the PPI model, generates independent samples.
}
\details{
We recommend running \code{rppi()} a number of times to ensure the choice of \code{maxden} is good. \code{rppi()} will error when \code{maxden} is too low.

The simulation uses a rejection-sampling algorithm with Dirichlet proposal \insertCite{@Appendix A.1.3 @scealy2023sc}{scorematchingad}.
Initially \code{n} Dirichlet proposals are generated. After rejection there are fewer samples remaining, say \eqn{n^*}{n*}.
The ratio \eqn{n^*/n}{n*/n} is used to guess the number of new Dirichlet proposals to generate until \code{n} samples of the PPI model are reached.

Advanced use: The number of Dirichlet proposals created at a time is limited such that the matrices storing the Dirchlet proposals are always smaller than \code{maxmemorysize} bytes (give or take a few bytes for wrapping).
Larger \code{maxmemorysize} leads to faster simulation so long as \code{maxmemorysize} bytes are reliably contiguously available in RAM.
}
\section{Functions}{
\itemize{
\item \code{rppi_egmodel()}: Simulates the 3-component PPI model from \insertCite{@Section 2.3, @scealy2023sc}{scorematchingad} and returns both simulations and model parameters.

}}
\examples{
beta0=c(-0.8, -0.8, -0.5)
AL = diag(nrow = 2)
bL = c(2, 3)
samp <- rppi(100,beta=beta0,AL=AL,bL=bL)
rppi_egmodel(1000)
}
\references{
\insertAllCited{}
}
\seealso{
Other PPI model tools: 
\code{\link{dppi}()},
\code{\link{ppi}()},
\code{\link{ppi_param_tools}},
\code{\link{ppi_robust}()}
}
\concept{PPI model tools}
