% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wsce.R
\name{wsce}
\alias{wsce}
\title{Computes the weighted structured covariance matrix estimator (WSCE)}
\usage{
wsce(
  pairwise_covariate_matrices,
  adj_matrix,
  dataset,
  mean_estim = NULL,
  sd_estim = NULL,
  grid_size = 100,
  parallelize = FALSE,
  ncores = 8,
  adj_positions = 1:nrow(adj_matrix),
  interaction_effects = list(),
  init = NULL,
  sce_init = NULL,
  use_bootstrap = FALSE,
  num_bootstrap_iters = 100,
  seed = 0,
  verbose = TRUE
)
}
\arguments{
\item{pairwise_covariate_matrices}{named list of square matrices}

\item{adj_matrix}{adjacency matrix of the spatial covariate}

\item{dataset}{the dataset given in matrix form}

\item{mean_estim}{mean vector estimate}

\item{sd_estim}{standard deviation vector estimate}

\item{grid_size}{grid-size for spatial effect}

\item{parallelize}{uses parallel-processing if TRUE}

\item{ncores}{number of cores for the parallelization}

\item{adj_positions}{positions within the adjacency matrix}

\item{interaction_effects}{list of interaction effects}

\item{init}{the initialization parameter vector}

\item{sce_init}{the sce-initialization parameter vector}

\item{use_bootstrap}{uses bootstrapping if TRUE}

\item{num_bootstrap_iters}{number of bootstrap simulations}

\item{seed}{a seed}

\item{verbose}{prints progress if TRUE}
}
\value{
Returns a named list with the following elements:

         parm,             estimated parameters of pairwise, spatial effects,
         average_effects,  average effects of the covariates,
         corrmat_estim,    estimator of the correlation matrix,
         covmat_estim,     estimator of the covariance matrix,
         bic,              the Bayesian information criterion (BIC),
         lambda,           the asymptotically optimal weight of the WSCE
}
\description{
This function computes the WSCE estimator for large covariances in the
presence of pairwise and spatial covariates from Metodiev et al. (2024).
}
\references{
Metodiev, M., Perrot-Dockès, M., Ouadah, S., Fosdick, B. K.,
Robin, S., Latouche, P., & Raftery, A. E. (2024). A Structured Estimator for
large Covariance Matrices in the Presence of Pairwise and Spatial Covariates.
arXiv preprint arXiv:2411.04520.
}
\keyword{internal}
