% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debit-map-total-n.R
\name{debit_map_total_n}
\alias{debit_map_total_n}
\title{Use DEBIT with hypothetical group sizes}
\usage{
debit_map_total_n(
  data,
  x1 = NULL,
  x2 = NULL,
  sd1 = NULL,
  sd2 = NULL,
  dispersion = 0:5,
  n_min = 1L,
  n_max = NULL,
  constant = NULL,
  constant_index = NULL,
  ...
)
}
\arguments{
\item{data}{Data frame with string columns \code{x1}, \code{x2}, \code{sd1}, and \code{sd2}, as
well as numeric column \code{n}. The first two are reported group means. \code{sd1}
and \code{sd2} are reported group SDs. \code{n} is the reported total sample size. It
is not very important whether a value is in \code{x1} or in \code{x2} because, after
the first round of tests, the function switches roles between \code{x1} and
\code{x2}, and reports the outcomes both ways. The same applies to \code{sd1} and
\code{sd2}. However, do make sure the \verb{x*} and \verb{sd*} values are paired
accurately, as reported.}

\item{x1, x2, sd1, sd2}{Optionally, specify these arguments as column names in
\code{data}.}

\item{dispersion}{Numeric. Steps up and down from half the \code{n} values.
Default is \code{0:5}, i.e., half \code{n} itself followed by five steps up and down.}

\item{n_min}{Numeric. Minimal group size. Default is 1.}

\item{n_max}{Numeric. Maximal group size. Default is \code{NULL}, i.e., no
maximum.}

\item{constant}{Optionally, add a length-2 vector or a list of length-2
vectors (such as a data frame with exactly two rows) to accompany the pairs
of dispersed values. Default is \code{NULL}, i.e., no constant values.}

\item{constant_index}{Integer (length 1). Index of \code{constant} or the first
\code{constant} column in the output tibble. If \code{NULL} (the default), \code{constant}
will go to the right of \code{n_change}.}

\item{...}{Arguments passed down to \code{\link[=debit_map]{debit_map()}}.}
}
\value{
A tibble with these columns:
\itemize{
\item \code{x} and \code{sd}, the group-wise reported input statistics, are repeated in
row pairs.
\item \code{n} is dispersed from half the input \code{n}, with \code{n_change} tracking the
differences.
\item \code{both_consistent} flags scenarios where both reported \code{x} and \code{sd} values
are consistent with the hypothetical \code{n} values.
\item \code{case} corresponds to the row numbers of the input data frame.
\item \code{dir} is \code{"forth"} in the first half of rows and \code{"back"} in the second
half. \code{"forth"} means that \code{x2} and \code{sd2} from the input are paired with the
larger dispersed \code{n}, whereas \code{"back"} means that \code{x1} and \code{sd1} are paired
with the larger dispersed \code{n}.
\item Other columns from \code{debit_map()} are preserved.
}
}
\description{
\code{debit_map_total_n()} extends DEBIT to cases where only group
means and standard deviations (SDs) were reported, not group sizes.

The function is analogous to \code{\link[=grim_map_total_n]{grim_map_total_n()}} and
\code{\link[=grimmer_map_total_n]{grimmer_map_total_n()}}, relying on the same infrastructure.
}
\section{Summaries with \code{\link[=audit_total_n]{audit_total_n()}}}{
 You can call
\code{\link[=audit_total_n]{audit_total_n()}} following up on \code{debit_map_total_n()}
to get a tibble with summary statistics. It will have these columns:
\itemize{
\item \code{x1}, \code{x2}, \code{sd1}, \code{sd2}, and \code{n} are the original inputs.
\item \code{hits_total} is the number of scenarios in which all of
\code{x1}, \code{x2}, \code{sd1}, and \code{sd2} are DEBIT-consistent. It is the sum
of \code{hits_forth} and \code{hits_back} below.
\item \code{hits_forth} is the number of both-consistent cases that result
from pairing \code{x2} and \code{sd2} with the larger dispersed \code{n} value.
\item \code{hits_back} is the same, except \code{x1} and \code{sd1} are
paired with the larger dispersed \code{n} value.
\item \code{scenarios_total} is the total number of test scenarios,
whether or not both \code{x1} and \code{sd1} as well as \code{x2} and \code{sd2}
are DEBIT-consistent.
\item \code{hit_rate} is the ratio of \code{hits_total} to \code{scenarios_total}.
}

Call \code{\link[=audit]{audit()}} following \code{\link[=audit_total_n]{audit_total_n()}} to summarize results
even further.
}

\examples{
# Run `debit_map_total_n()` on data like these:
df <- tibble::tribble(
  ~x1,  ~x2,  ~sd1,  ~sd2,  ~n,
  "0.30", "0.28", "0.17", "0.10", 70,
  "0.41", "0.39", "0.09", "0.15", 65
)
df

debit_map_total_n(df)
}
\references{
Bauer, P. J., & Francis, G. (2021). Expression of Concern: Is It
Light or Dark? Recalling Moral Behavior Changes Perception of Brightness.
\emph{Psychological Science}, 32(12), 2042–2043.
https://journals.sagepub.com/doi/10.1177/09567976211058727

Heathers, J. A. J., & Brown, N. J. L. (2019). DEBIT: A Simple Consistency
Test For Binary Data. https://osf.io/5vb3u/.
}
\seealso{
\code{\link[=function_map_total_n]{function_map_total_n()}}, which created the present function using
\code{\link[=debit_map]{debit_map()}}.
}
