% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function-map.R
\name{function_map}
\alias{function_map}
\title{Create new \verb{*_map()} functions}
\usage{
function_map(
  .fun,
  .reported,
  .name_test,
  .name_key_result = "consistency",
  .name_class = NULL,
  .args_disabled = NULL,
  .col_names = NULL,
  .col_control = NULL,
  .col_filler = NULL,
  ...
)
}
\arguments{
\item{.fun}{Single-case consistency testing function that will be applied to
each row in a data frame. The function must return a single logical value,
i.e., \code{TRUE}, \code{FALSE}, or \code{NA}.}

\item{.reported}{String. Names of the columns to be tested.}

\item{.name_test}{String (length 1). Plain-text name of the consistency test,
such as \code{"GRIM"}.}

\item{.name_key_result}{(Experimental) Optionally, a single string that will
be the name of the key result column in the output. Default is
\code{"consistency"}.}

\item{.name_class}{String. Optionally, one or more classes to be added to the
output data frame. Default is \code{NULL}, i.e., no extra class (but see
\emph{Details}).}

\item{.args_disabled}{Optionally, a string vector with names of arguments of
the \verb{*_scalar()} function that don't work with the factory-made function.
If the user  tries to specify these arguments, an informative error will be
thrown.}

\item{.col_names}{(Experimental) Optionally, a string vector with the names
of additional columns that are derived from the \verb{*_scalar()} function.
Requires \code{.col_control} and \code{.col_filler} specifications.}

\item{.col_control}{(Experimental) Optionally, a single string with the name
of the \verb{*_scalar()} function's logical argument that controls if the
columns named in \code{.col_names} will be displayed.}

\item{.col_filler}{(Experimental) Optionally, a vector specifying the values
of \code{.col_names} columns in rows where the \verb{*_scalar()} function only
returned the \code{consistency} value.}

\item{...}{These dots must be empty.}
}
\value{
A factory-made function with these arguments:
\itemize{
\item \code{data}: Data frame with all the columns named in \code{.reported}. It must
have columns named after the key arguments in \code{.fun}. Other columns are
permitted.
\item Arguments named after the \code{.reported} values. They can be specified as the
names of \code{data} columns so that the function will rename that column using
the \code{.reported} name.
\item \code{reported}, \code{fun}, \code{name_class}: Same as when calling \code{function_map()} but
spelled without dots. You can override these defaults when calling the
factory-made function.
\item \code{...}: Arguments passed down to \code{.fun}. This does not include the
column-identifying arguments derived from \code{.reported}.
}
}
\description{
\code{function_map()} creates new basic mapper functions for
consistency tests, such as \code{\link[=grim_map]{grim_map()}} or \code{\link[=debit_map]{debit_map()}}.

For context, see \href{https://lhdjung.github.io/scrutiny/articles/consistency-tests.html#creating-basic-mappers-with-function_map}{\emph{Creating basic mappers with \code{function_map()}}}.
}
\details{
The output tibble returned by the factory-made function will inherit
one or two classes independently of the \code{.name_class} argument:
\itemize{
\item It will inherit a class named \code{"scr_{tolower(.name_test)}_map"}; for
example, the class is \code{"scr_grim_map"} if \code{.name_test} is \code{"GRIM"}.
\item If a \code{rounding} argument is specified via \code{...}, or else if \code{.fun} has a
\code{rounding} argument with a default, the output tibble will inherit a class
named \code{"scr_rounding_{rounding}"}; for example,
\code{"scr_rounding_up_or_down"}.
}
}
\section{Value returned by the factory-made function}{
 A tibble that includes
\code{"consistency"}: a logical column showing whether the values to its left
are mutually consistent (\code{TRUE}) or not (\code{FALSE}).
}

\examples{
# Basic test implementation for "SCHLIM",
# a mock test with no real significance:
schlim_scalar <- function(y, n) {
  (y / 3) > n
}

# Let the function factory produce
# a mapper function for SCHLIM:
schlim_map <- function_map(
  .fun = schlim_scalar,
  .reported = c("y", "n"),
  .name_test = "SCHLIM"
)

# Example data:
df1 <- tibble::tibble(y = 16:25, n = 3:12)

# Call the "factory-made" function:
schlim_map(df1)
}
