% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzyoverlay.R
\name{fuzzyoverlay}
\alias{fuzzyoverlay}
\title{spatial fuzzy overlay}
\usage{
fuzzyoverlay(formula, data, method = "and")
}
\arguments{
\item{formula}{A formula of spatial fuzzy overlay.}

\item{data}{A data.frame or tibble of discretized data.}

\item{method}{(optional) Overlay methods. When \code{method} is \code{and}, use \code{min} to do
fuzzy overlay; and when \code{method} is \code{or},use \code{max} to do fuzzy overlay. Default is \code{and}.}
}
\value{
A numeric vector.
}
\description{
spatial fuzzy overlay
}
\note{
Independent variables in the \code{data} provided to \code{fuzzyoverlay()} must be discretized
variables, and dependent variable are continuous variable.
}
\examples{
set.seed(42)
sim = tibble::tibble(y = stats::runif(7,0,10),
                     x1 = c(1,rep(2,3),rep(3,3)),
                     x2 = c(rep(1,2),rep(2,2),rep(3,3)))
fo1 = fuzzyoverlay(y~x1+x2,data = sim, method = 'and')
fo1
fo2 = fuzzyoverlay(y~x1+x2,data = sim, method = 'or')
fo2

}
